@extends('layouts.auth')

@section('title', 'تسجيل الدخول')

@section('content')

    <div x-data="{ twoFAOpen: false }" class="relative">

        {{-- ===== PAGE LAYOUT ===== --}}
        <div class="relative flex min-h-screen w-full flex-row overflow-hidden">

            {{-- ===== LEFT SIDE (FORM) ===== --}}
            <div class="flex w-full flex-col justify-center bg-background-light dark:bg-background-dark
                       px-6 py-12 lg:w-[45%] lg:px-16 xl:px-24
                       relative z-10 border-l border-border-subtle/50 dark:border-white/5">

                {{-- Logo --}}
                <div class="mb-12 flex items-center gap-4">
                    <img src="https://swangroup.sa/wp-content/uploads/2023/09/5FA061E1-81B7-477E-A650-A3EBE6B30088-e1734439779218.png"
                        width="120" height="120" alt="Swan Salon">
                </div>

                {{-- Heading --}}
                <div class="mb-10 flex flex-col gap-3">
                    <h1 class="text-4xl font-serif font-medium leading-tight text-text-main dark:text-white">
                        أهلاً بكِ مجدداً
                    </h1>
                    <p class="text-base text-text-muted dark:text-gray-400">
                        بوابة الدخول لنظام صالون سوان
                    </p>
                </div>

                {{-- FORM --}}
                <form class="flex flex-col gap-6 w-full max-w-[480px]">

                    {{-- Email --}}
                    <div class="flex flex-col gap-2 group">
                        <label class="text-sm font-medium group-focus-within:text-primary">
                            البريد الإلكتروني
                        </label>
                        <div class="relative">
                            <span
                                class="material-symbols-outlined absolute right-4 top-1/2 -translate-y-1/2 text-text-muted">
                                mail
                            </span>
                            <input type="email" placeholder="name@salon.com" class="h-14 w-full rounded-xl border border-border-subtle
                                          bg-surface-light dark:bg-surface-dark
                                          pr-12 px-4 text-base
                                          focus:border-primary focus:ring-1 focus:ring-primary
                                          transition-all">
                        </div>
                    </div>

                    {{-- Password --}}
                    <div class="flex flex-col gap-2 group">
                        <label class="text-sm font-medium group-focus-within:text-primary">
                            كلمة المرور
                        </label>
                        <div class="relative flex items-center h-14 rounded-xl
                                   border border-border-subtle bg-surface-light dark:bg-surface-dark
                                   focus-within:border-primary focus-within:ring-1 focus-within:ring-primary">

                            <span class="material-symbols-outlined absolute right-4 text-text-muted">
                                lock
                            </span>

                            <input type="password" placeholder="********"
                                class="flex-1 bg-transparent pr-12 px-4 focus:ring-0">

                            <button type="button" class="px-4 text-text-muted hover:text-primary">
                                <span class="material-symbols-outlined">visibility_off</span>
                            </button>
                        </div>
                    </div>

                    {{-- Remember + Forgot --}}
                    <div class="flex justify-between items-center text-sm">
                        <label class="flex items-center gap-2 cursor-pointer">
                            <input type="checkbox" class="rounded border-gray-300 text-primary">
                            <span class="text-text-muted">تذكرني</span>
                        </label>
                        <a href="#" class="text-primary hover:underline">
                            نسيت كلمة المرور؟
                        </a>
                    </div>

                    {{-- LOGIN BUTTON --}}
                    <button type="button" @click="twoFAOpen = true" class="mt-6 h-14 rounded-xl bg-primary text-white font-bold
                               hover:bg-primary-dark transition-all
                               flex items-center justify-center gap-3">

                        <span>تسجيل الدخول</span>
                        <span class="material-symbols-outlined rtl:rotate-180">
                            arrow_forward
                        </span>
                    </button>

                </form>

                {{-- Footer --}}
                <div class="mt-12 text-sm text-text-muted">
                    ليس لديك حساب؟
                    <a href="#" class="text-primary font-bold hover:underline">
                        تواصل مع الإدارة
                    </a>
                </div>
            </div>

            {{-- ===== RIGHT SIDE (IMAGE) ===== --}}
            <div class="hidden lg:flex lg:w-[55%] relative bg-[#2d1b1b]">
                <div class="absolute inset-0 bg-cover bg-center"
                    style="background-image:url('https://lh3.googleusercontent.com/aida-public/AB6AXuAXkC4fIgHQ8gDjHUIJbNp6aoP8TuH_PIR0hQN5u7tSFV-aH6Wz09ZMrSYtlpnyq_9Vra1kt84ZVU8kDladCGNsR8rQZlXyaoKQo3oiNJ39fZTBewn-KgmnhMNIjKHOuTOIPKn1pz4-9POW03SMGiIYXltUk27bbLGFiRaYg8DhgdH9xAEIqqKwazXAJo20E3W5L2M_hBa4VC5P-4YAnI-FG24sQdC5XWgaOPahREcpnmyGjkLyFSTk23jxUZhqjMrNoc12Yprc4-Q')">
                </div>
                <div class="absolute inset-0 bg-gradient-to-t from-primary-dark/90 to-transparent"></div>
            </div>
        </div>

        {{-- ===== 2FA POPUP COMPONENT ===== --}}
        <x-auth.two-factor-popup />

    </div>

@endsection