{{-- Calendar Booking Drawer --}}
<div id="calendarBookingDrawer" class="fixed inset-y-0 left-0 w-[420px] bg-white dark:bg-[#201c1c]
           shadow-2xl transform -translate-x-full transition-transform duration-300
           z-50 flex flex-col border-r border-gray-200 dark:border-gray-800">

    {{-- Header --}}
    <div class="px-6 py-4 border-b border-gray-100 dark:border-gray-800
                flex items-center justify-between
                bg-gray-50 dark:bg-[#1a1616]">
        <h3 class="text-lg font-bold text-gray-900 dark:text-white">
            تفاصيل الحجز
        </h3>
        <button onclick="closeCalendarBooking()" class="size-8 flex items-center justify-center rounded-full
                   hover:bg-gray-200 dark:hover:bg-gray-700
                   text-gray-500 transition-colors">
            <span class="material-symbols-outlined">close</span>
        </button>
    </div>

    {{-- Content --}}
    <div class="flex-1 overflow-y-auto p-6 space-y-6">

        {{-- Status + Ref --}}
        <div class="flex items-center gap-2">
            <span class="px-3 py-1 rounded-full bg-emerald-100 text-emerald-700
                       text-xs font-bold border border-emerald-200">
                مؤكد
            </span>
            <span class="text-xs text-gray-400">
                REF: #BK-2025-892
            </span>
        </div>

        {{-- Client --}}
        <div class="flex items-start gap-4">
            <div class="size-14 rounded-full bg-cover bg-center
                       ring-4 ring-gray-50 dark:ring-[#1a1616]"
                style="background-image:url('https://lh3.googleusercontent.com/aida-public/AB6AXuCuWupAqEa1jWv8l-u6rGGZN0D7YpLkbLM-1Tq4T9jdCMQcPaLnK5hwVRx1DiiUCfSpRurjKLBVldH_1it1HsvzhJyQ_DSqWa9HiS0ULGohAijh25WjvliuTruMz5lb9TUqn5EWJep2rFNgCLI4hjfH7kZ_G5fI0iZlTnvg2j4kKo1Owdxvc8B0h0HVq-Y8GS6oafNoP2eMyeSgqrIwBCDo9rr6T5dHcbB6oGsNauhOdI9mKsH-pdQFx8wpIZrG-ajViXJuoKj6sK0');">
            </div>

            <div>
                <h4 class="font-bold text-gray-900 dark:text-white text-lg">
                    أمل أحمد
                </h4>

                <div class="flex items-center gap-1.5 text-sm text-gray-500 mt-1">
                    <span class="material-symbols-outlined text-[16px] text-gray-400">
                        call
                    </span>
                    <span dir="ltr" class="font-medium">
                        +966 55 123 4567
                    </span>
                </div>
            </div>

            <button class="mr-auto text-primary text-sm font-bold hover:underline">
                عرض الملف
            </button>
        </div>

        <div class="h-px bg-gray-100 dark:bg-gray-800"></div>

        {{-- Date & Time --}}
        <div class="grid grid-cols-2 gap-4">
            <div class="bg-gray-50 dark:bg-gray-800 p-3 rounded-xl
                        border border-gray-100 dark:border-gray-700">
                <span class="block text-xs text-gray-500 mb-1">
                    التاريخ
                </span>
                <div class="flex items-center gap-2 font-bold text-sm">
                    <span class="material-symbols-outlined text-primary text-[18px]">
                        event
                    </span>
                    <span>22 ديسمبر 2025</span>
                </div>
            </div>

            <div class="bg-gray-50 dark:bg-gray-800 p-3 rounded-xl
                        border border-gray-100 dark:border-gray-700">
                <span class="block text-xs text-gray-500 mb-1">
                    الوقت
                </span>
                <div class="flex items-center gap-2 font-bold text-sm">
                    <span class="material-symbols-outlined text-primary text-[18px]">
                        schedule
                    </span>
                    <span>10:00 ص - 11:30 ص</span>
                </div>
            </div>
        </div>

        {{-- Services --}}
        <div>
            <h5 class="font-bold text-sm mb-3 text-gray-900 dark:text-gray-100">
                الخدمات (2)
            </h5>

            <div class="space-y-3">

                {{-- Service --}}
                <div class="flex items-center justify-between p-3 rounded-xl
                           border border-gray-200 dark:border-gray-700
                           hover:border-primary/30 transition-colors
                           bg-white dark:bg-gray-800 shadow-sm">
                    <div class="flex items-center gap-3">
                        <div class="size-10 rounded-lg bg-primary/10
                                   text-primary flex items-center justify-center">
                            <span class="material-symbols-outlined text-[20px]">
                                content_cut
                            </span>
                        </div>
                        <div>
                            <p class="text-sm font-bold">قص شعر</p>
                            <p class="text-xs text-gray-500">
                                مع سارة • 45 دقيقة
                            </p>
                        </div>
                    </div>
                    <span class="font-bold text-sm">150 ر.س</span>
                </div>

                {{-- Service --}}
                <div class="flex items-center justify-between p-3 rounded-xl
                           border border-gray-200 dark:border-gray-700
                           hover:border-primary/30 transition-colors
                           bg-white dark:bg-gray-800 shadow-sm">
                    <div class="flex items-center gap-3">
                        <div class="size-10 rounded-lg bg-primary/10
                                   text-primary flex items-center justify-center">
                            <span class="material-symbols-outlined text-[20px]">
                                brush
                            </span>
                        </div>
                        <div>
                            <p class="text-sm font-bold">صبغة كاملة</p>
                            <p class="text-xs text-gray-500">
                                مع سارة • 45 دقيقة
                            </p>
                        </div>
                    </div>
                    <span class="font-bold text-sm">250 ر.س</span>
                </div>

            </div>
        </div>

        {{-- Summary --}}
        <div class="bg-gray-50 dark:bg-gray-800 rounded-xl p-5 space-y-2
                   border border-gray-100 dark:border-gray-700">

            <div class="flex justify-between text-sm text-gray-500">
                <span>المجموع</span>
                <span class="font-medium">400 ر.س</span>
            </div>

            <div class="flex justify-between text-sm text-gray-500">
                <span>الضريبة (15%)</span>
                <span class="font-medium">60 ر.س</span>
            </div>

            <div class="border-t border-gray-200 dark:border-gray-700
                       my-2 pt-3 flex justify-between
                       font-bold text-lg">
                <span>الإجمالي</span>
                <span class="text-primary">460 ر.س</span>
            </div>

        </div>

    </div>

    {{-- Footer --}}
    <div class="p-4 border-t border-gray-100 dark:border-gray-800
               bg-white dark:bg-[#1a1616] flex gap-3">
        <button class="flex-1 py-3 rounded-xl border border-gray-300
                   text-gray-700 font-bold hover:bg-gray-50 transition-colors">
            تعديل
        </button>
        <button class="flex-[2] py-3 rounded-xl bg-primary
                   text-white font-bold hover:bg-primary-dark
                   shadow-lg shadow-primary/20 transition-colors">
            إتمام الدفع
        </button>
    </div>

</div>