{{-- Mobile Overlay --}}
<div x-show="sidebarOpen" x-transition.opacity @click="sidebarOpen = false"
    class="fixed inset-0 bg-black/40 z-30 lg:hidden"></div>

{{-- Sidebar --}}
<aside @keydown.escape.window="sidebarOpen = false" class="
        fixed inset-y-0 right-0 z-40
        w-72
        bg-[#faf8fc] dark:bg-[#1e1424]
        border-l border-[#efe7f3] dark:border-[#2d2235]
        transform transition-transform duration-300 ease-in-out
        lg:static lg:translate-x-0
        h-full overflow-y-auto shrink-0 shadow-sm
    " :class="sidebarOpen ? 'translate-x-0' : 'translate-x-full lg:translate-x-0'">
    <div class="flex flex-col justify-between h-full">

        {{-- Top --}}
        <div class="flex flex-col gap-6 p-6">

            {{-- Logo --}}
            <div class="flex items-center justify-center gap-3">
                <img src="https://swangroup.sa/wp-content/uploads/2023/09/5FA061E1-81B7-477E-A650-A3EBE6B30088-e1734439779218.png"
                    width="70" height="70" alt="">

            </div>

            {{-- Navigation --}}
            <nav class="flex flex-col gap-2">

                <x-sidebar-item href="{{ route('dashboard') }}" icon="dashboard"
                    :active="request()->routeIs('dashboard')" @click="sidebarOpen = false">
                    لوحة التحكم
                </x-sidebar-item>

                <x-sidebar-item href="{{ route('calendar') }}" icon="calendar_month"
                    :active="request()->routeIs('calendar*')" @click="sidebarOpen = false">
                    التقويم
                </x-sidebar-item>

                <x-sidebar-item href="{{ route('bookings') }}" icon="calendar_month"
                    :active="request()->routeIs('bookings*')" @click="sidebarOpen = false">
                    الحجوزات
                </x-sidebar-item>

                <x-sidebar-item href="{{ route('customers') }}" icon="group" :active="request()->routeIs('customers*')"
                    @click="sidebarOpen = false">
                    العملاء
                </x-sidebar-item>



                <x-sidebar-item href="{{ route('reminders') }}" icon="notifications"
                    :active="request()->routeIs('reminders*')" @click="sidebarOpen = false">
                    التنبيهات
                </x-sidebar-item>

                {{-- Admin Sections --}}

                <div class="p-6 border-t border-[#efe7f3] dark:border-[#2d2235]">
                    <p>الإدارة</p>
                </div>

                {{-- Services Dropdown --}}
                <div x-data="{
        open: {{ request()->routeIs('services*') ? 'true' : 'false' }}
    }" class="space-y-1">

                    {{-- Main Services Button --}}
                    <button @click="open = !open" class="w-full flex items-center justify-between px-4 py-3 rounded-xl
               transition-colors
               {{ request()->routeIs('services*')
    ? 'bg-primary/10 text-primary'
    : 'text-text-secondary hover:bg-surface-alt hover:text-text-main'
               }}">
                        <div class="flex items-center gap-3">
                            <span class="material-symbols-outlined">spa</span>
                            <span class="text-sm font-bold">الخدمات</span>
                        </div>

                        <span class="material-symbols-outlined text-[18px] transition-transform duration-200"
                            :class="open ? 'rotate-180' : ''">
                            expand_more
                        </span>
                    </button>

                    {{-- Sub Menu --}}
                    <div x-show="open" x-collapse class="pr-6 space-y-1">

                        {{-- All Services --}}
                        <x-sidebar-item href="{{ route('services') }}" icon="spa"
                            :active="request()->routeIs('services')" @click="sidebarOpen = false">
                            كل الخدمات
                        </x-sidebar-item>

                        {{-- Service Categories --}}
                        <x-sidebar-item href="{{ route('services.categories') }}" icon="category"
                            :active="request()->routeIs('services.categories*')" @click="sidebarOpen = false">
                            تصنيفات الخدمات
                        </x-sidebar-item>

                    </div>

                </div>

                <x-sidebar-item href="{{ route('finance') }}" icon="receipt" :active="request()->routeIs('finance*')"
                    @click="sidebarOpen = false">
                    الفواتير
                </x-sidebar-item>

                <x-sidebar-item href="{{ route('coupons') }}" icon="local_offer"
                    :active="request()->routeIs('coupons*')" @click="sidebarOpen = false">
                    الكوبونات
                </x-sidebar-item>

                <x-sidebar-item href="{{ route('staff') }}" icon="id_card" :active="request()->routeIs('staff*')"
                    @click="sidebarOpen = false">
                    الموظفات
                </x-sidebar-item>

                <x-sidebar-item href="{{ route('reports') }}" icon="analytics" :active="request()->routeIs('reports*')"
                    @click="sidebarOpen = false">
                    التقارير
                </x-sidebar-item>


                <div x-data="{
                    open: {{ request()->routeIs('settings*') ? 'true' : 'false' }}
                    }" class="space-y-1">

                    {{-- Main Settings Button --}}
                    <button @click="open = !open" class="w-full flex items-center justify-between px-4 py-3 rounded-xl
                            transition-colors
                            {{ request()->routeIs('settings*')
    ? 'bg-primary/10 text-primary'
    : 'text-text-secondary hover:bg-surface-alt hover:text-text-main'
                            }}">
                        <div class="flex items-center gap-3">
                            <span class="material-symbols-outlined">settings</span>
                            <span class="text-sm font-bold">الإعدادات</span>
                        </div>

                        <span class="material-symbols-outlined text-[18px] transition-transform duration-200"
                            :class="open ? 'rotate-180' : ''">
                            expand_more
                        </span>
                    </button>

                    {{-- Sub Menu --}}
                    <div x-show="open" x-collapse class="pr-6 space-y-1">

                        {{-- General Settings --}}
                        <x-sidebar-item href="{{ route('settings.general') }}" icon="admin_panel_settings"
                            :active="request()->routeIs('settings.general*')" @click="sidebarOpen = false">
                            إعدادات النظام
                        </x-sidebar-item>

                        {{-- Activity Log --}}
                        <x-sidebar-item href="{{ route('settings.activity') }}" icon="analytics"
                            :active="request()->routeIs('settings.activity*')" @click="sidebarOpen = false">
                            سجل النشاط
                        </x-sidebar-item>

                        {{-- Notifications --}}
                        <!-- <x-sidebar-item href="{{ route('settings.notifications') }}" icon="notifications"
                            :active="request()->routeIs('settings.notifications*')" @click="sidebarOpen = false">
                            التنبيهات
                        </x-sidebar-item> -->



                    </div>

                </div>




            </nav>
        </div>



    </div>
</aside>