@props([
    'type' => 'default'
])

@php
    $badges = [
        'success' => 'bg-emerald-100 text-emerald-700 border border-emerald-200',
        'warning' => 'bg-amber-100 text-amber-700 border border-amber-200',
        'danger'  => 'bg-red-100 text-red-700 border border-red-200',
        'info'    => 'bg-blue-100 text-blue-700 border border-blue-200',
        'default' => 'bg-gray-100 text-gray-700 border border-gray-200',
    ];

    $labels = [
        'success' => 'مؤكد',
        'warning' => 'قيد الانتظار',
        'danger'  => 'ملغي',
        'info'    => 'معلومة',
        'default' => 'غير محدد',
    ];

    $badgeClass = $badges[$type] ?? $badges['default'];
    $label      = $slot->isEmpty()
        ? ($labels[$type] ?? $labels['default'])
        : $slot;
@endphp

<span
    {{ $attributes->merge([
        'class' => "inline-flex items-center px-2.5 py-1 rounded-full text-xs font-bold {$badgeClass}"
    ]) }}
>
    {{ $label }}
</span>
