@props([
    'variant' => 'primary', // primary | secondary | outline
    'type' => 'button'
])

@php
    $styles = [
        'primary' => 'bg-primary text-white hover:bg-primary-dark shadow-md shadow-primary/20',
        'secondary' => 'bg-gray-100 text-gray-800 hover:bg-gray-200',
        'outline' => 'border border-gray-300 text-gray-700 hover:bg-gray-50',
    ];
@endphp

<button
    type="{{ $type }}"
    {{ $attributes->merge([
        'class' => "px-4 py-2 rounded-lg font-bold transition-all active:scale-95 {$styles[$variant]}"
    ]) }}
>
    {{ $slot }}
</button>
