<!DOCTYPE html>
<html dir="rtl" lang="ar" class="light">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>@yield('title', 'تسجيل الدخول')</title>

    <link
        href="https://fonts.googleapis.com/css2?family=Manrope:wght@400;500;700;800&amp;family=Noto+Sans+Arabic:wght@400;500;700;800&amp;display=swap"
        rel="stylesheet" />
    <link
        href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:wght,FILL@100..700,0..1&amp;display=swap"
        rel="stylesheet" />

    <link href="https://fonts.googleapis.com/css2?family=Rubik:ital,wght@0,300..900;1,300..900&display=swap"
        rel="stylesheet">


    <script src="https://cdn.tailwindcss.com?plugins=forms,container-queries"></script>
    <script defer src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js"></script>

    <script id="tailwind-config">
        tailwind.config = {
            darkMode: "class",
            theme: {
                extend: {
                    colors: {
                        "primary": "#8d2739",
                        "primary-soft": "#f3e8f9",
                        "background-light": "#f7f6f8",
                        "background-dark": "#1c1121",
                        "text-main": "#170e1b",
                        "text-sub": "#7f4e97",
                    },
                    fontFamily: {
                        "display": ["Rubik", "sans-serif"],
                        "body": ["Rubik", "sans-serif"],
                    },
                    borderRadius: { "DEFAULT": "0.5rem", "lg": "0.75rem", "xl": "1rem", "2xl": "1.5rem", "full": "9999px" },
                },
            },
        }
    </script>
    <style>
        body {
            font-family: "Rubik", "sans-serif";
        }

        .material-symbols-outlined {
            font-variation-settings: 'FILL' 0, 'wght' 400, 'GRAD' 0, 'opsz' 24;
        }

        /* Custom scrollbar for better aesthetic */
        ::-webkit-scrollbar {
            width: 6px;
        }

        ::-webkit-scrollbar-track {
            background: transparent;
        }

        ::-webkit-scrollbar-thumb {
            background: #e0d5e5;
            border-radius: 10px;
        }

        ::-webkit-scrollbar-thumb:hover {
            background: #a219e6;
        }

        [x-cloak] {
            display: none !important;
        }
    </style>
</head>

<body class="bg-background-light dark:bg-background-dark font-display">

    @yield('content')

    @stack('scripts')
</body>

</html>