@extends('layouts.app')

@section('title', 'التقويم')

@section('content')

    <!-- Page Header -->
    <header class="p-4  md:px-12">
        <div class=" mx-auto flex flex-col gap-6">
            <div class="flex items-center gap-2 text-sm">
                <a class="text-text-secondary hover:text-primary transition-colors" href="#">الرئيسية</a>
                <span class="text-text-tertiary text-xs material-symbols-outlined rotate-180">chevron_right</span>
                <span class="text-text-secondary hover:text-primary transition-color">التقويم</span>
            </div>
            <div class="flex flex-wrap justify-between items-end gap-4">
                <div class="flex flex-col gap-2">
                    <h2 class="text-text-main text-3xl md:text-4xl font-extrabold tracking-tight">التقويم</h2>
                    <p class="text-text-secondary text-base max-w-2xl font-medium">التقويم الكامل لمركزك. يمكنك إضافة حجوزات
                        جديدة وتعديل حجوزات موجودة.
                    </p>
                </div>
                <div class="flex gap-3">

                    <button onclick="openBookingDrawer()" class="bg-primary text-white px-6 py-3 rounded-xl">
                        إضافة حجز جديد
                    </button>
                </div>
            </div>
        </div>
    </header>
    <!-- end page header -->

    <div class="flex flex-col h-full bg-white">

        {{-- Toolbar --}}
        @include('components.calendar.toolbar')

        {{-- Week Days --}}
        @include('components.calendar.week-header')

        {{-- Calendar Body --}}
        <div class="flex flex-1 overflow-hidden">

            {{-- Time Column --}}
            @include('components.calendar.time-column')

            {{-- Calendar Grid --}}
            @include('components.calendar.grid')

        </div>

    </div>

    {{-- Booking Drawer --}}
    @include('components.calendar.booking-drawer')

    @push('scripts')
        <script>
            function openCalendarBooking() {
                document.getElementById('calendarBookingDrawer')
                    ?.classList.remove('-translate-x-full')
            }

            function closeCalendarBooking() {
                document.getElementById('calendarBookingDrawer')
                    ?.classList.add('-translate-x-full')
            }
        </script>
    @endpush

@endsection