@extends('layouts.app')

@section('title', 'إدارة العملاء')

@section('content')

    <!-- Page Header -->
    <header class="p-4  md:px-12">
        <div class=" mx-auto flex flex-col gap-6">
            <div class="flex items-center gap-2 text-sm">
                <a class="text-text-secondary hover:text-primary transition-colors" href="#">الرئيسية</a>
                <span class="text-text-tertiary text-xs material-symbols-outlined rotate-180">chevron_right</span>
                <span class="text-text-secondary hover:text-primary transition-color">مركز العملاء</span>
            </div>
            <div class="flex flex-wrap justify-between items-end gap-4">
                <div class="flex flex-col gap-2">
                    <h2 class="text-text-main text-3xl md:text-4xl font-extrabold tracking-tight">إدارة العملاء</h2>
                    <p class="text-text-secondary text-base max-w-2xl font-medium">إدارة العملاء الكاملة الخاصة بالمركز.
                    </p>
                </div>
                <div class="flex gap-3">
                    <button
                        class="px-5 py-2.5 rounded-lg bg-primary text-white font-bold text-sm hover:bg-primary/90 transition-colors shadow-md flex items-center gap-2">
                        <span class="material-symbols-outlined text-[20px]">add</span>
                        إضافة عميل جديد
                    </button>
                </div>
            </div>
        </div>
    </header>
    <!-- end page header -->

    <div class="flex-1 flex overflow-hidden">
        <div
            class="w-1/3 min-w-[320px] max-w-[400px] bg-white dark:bg-surface-dark border-l border-gray-100 dark:border-gray-800 flex flex-col z-10 shadow-lg">
            <div class="p-5 border-b border-gray-100 dark:border-gray-800 space-y-4 bg-gray-50/50 dark:bg-surface-dark">
                <div class="relative group">
                    <span
                        class="material-symbols-outlined absolute top-1/2 right-3 -translate-y-1/2 text-text-secondary group-focus-within:text-primary transition-colors">search</span>
                    <input
                        class="w-full h-11 pr-10 pl-4 rounded-xl bg-white dark:bg-background-dark border border-gray-200 dark:border-gray-700 text-sm focus:ring-1 focus:ring-primary focus:border-primary text-text-main dark:text-white placeholder-gray-400 shadow-sm transition-all"
                        placeholder="بحث بالاسم أو رقم الهاتف..." type="text" />
                </div>

            </div>
            <div class="flex-1 overflow-y-auto p-3 space-y-2 bg-gray-50/30 dark:bg-transparent">
                <div
                    class="p-3 rounded-xl bg-white dark:bg-primary/20 border border-primary/20 shadow-sm cursor-pointer flex items-center gap-4 transition-all relative overflow-hidden group">
                    <div class="absolute left-0 top-0 bottom-0 w-1 bg-primary"></div>
                    <div class="relative">
                        <div class="h-14 w-14 rounded-full bg-cover bg-center border-2 border-white dark:border-gray-700 shadow-md"
                            data-alt="Portrait of Sarah Mohammed"
                            style="background-image: url('https://lh3.googleusercontent.com/aida-public/AB6AXuCL7k6lbUncaETsMnB2EbLk04gtp3VxPg2B10BY7KFvp4wZ_CVGr3DfFsBZJPxMqjZ_jrTf5zs0DJOsNsD7SJ7DzEy-0iZvd1bhZf598UkNQClTggbcS8BFhI3HyIpeyS0WpaDir4WuJ2JxJsCsARt-HyU_UpH1709JpbuDR-p2w9yxErlAFZ21JBM5E3LKfTO-nIgeL0hVfdzhSJ6XB3vlGSQOIyut6P54ER619FSiFJmjOWDd9zPX8o7EuQ1f_KnB2PRKZBrHdFI');">
                        </div>

                    </div>
                    <div class="flex-1 min-w-0">
                        <div class="flex justify-between items-center mb-1">
                            <h3 class="text-base font-bold text-text-main dark:text-white truncate">سارة محمد</h3>
                            <span
                                class="text-[10px] text-primary font-medium bg-primary-light px-2 py-0.5 rounded-full">10:30
                                ص</span>
                        </div>
                        <p class="text-xs text-text-secondary truncate flex items-center gap-1">
                            <span class="material-symbols-outlined text-[10px]">phone</span> +966 55 123 4567
                        </p>
                    </div>
                </div>
                <div
                    class="p-3 rounded-xl bg-white dark:bg-surface-dark hover:bg-gray-50 dark:hover:bg-gray-800 cursor-pointer flex items-center gap-4 transition-colors border border-transparent hover:border-gray-200 dark:hover:border-gray-700">
                    <div class="h-12 w-12 rounded-full bg-cover bg-center border border-gray-100 dark:border-gray-700"
                        data-alt="Portrait of Nora Ahmed"
                        style="background-image: url('https://lh3.googleusercontent.com/aida-public/AB6AXuCuYs7POy3mv9qotgyzh0axBkG7uz2JQYdtNiCoGrjnkvjq4iyeGa6DlNl73pYRB5NB0r42g98xWTLsjyac4HOq2B5_lFg-h8vjApbuTGNSzgZ7sdHiMMbuxyDI6iBuQ1tccY5N9Ceq0Y2cFmLJ60LStaJeqcE9_QDLovbkp9tGuF408mLaDnfbK8GwBr4ycIOxnQ571E1CV6JEyfWAX4cdct_VyYINxLc_bFtF8OfZyj1QgCE7HZIpF69mvDaxVCUXlxvA8K6MVH8');">
                    </div>
                    <div class="flex-1 min-w-0">
                        <div class="flex justify-between items-center mb-1">
                            <h3 class="text-sm font-medium text-text-main dark:text-white truncate">نورة أحمد</h3>
                            <span class="text-[10px] text-gray-400">أمس</span>
                        </div>
                        <p class="text-xs text-text-secondary truncate">+966 50 987 6543</p>
                    </div>
                </div>
                <div
                    class="p-3 rounded-xl bg-white dark:bg-surface-dark hover:bg-gray-50 dark:hover:bg-gray-800 cursor-pointer flex items-center gap-4 transition-colors border border-transparent hover:border-gray-200 dark:hover:border-gray-700">
                    <div class="h-12 w-12 rounded-full bg-cover bg-center grayscale opacity-80"
                        data-alt="Portrait of Laila Khalid"
                        style="background-image: url('https://lh3.googleusercontent.com/aida-public/AB6AXuDtVHF96zmcDnRCuMeqO45Uw0KeaV7ME1SciYWre5FOIqKVkdFf2RP3z-A1gatJbYywK15dFFfXRZzasCNi_FI-_0sA4X3PigU3oqYwXLniK1BoGgsvxhVFLAkLjEsC7qEa_AOAWLtD28J8AbMbYllYIE65sL3U95AqCBZmMeA9Pcwzn1OlHhZWl3OSWTU0c2x-olGytm0PRO7A1-iAnyIGfEzycREmP5wSCQiD0lrjwzJgUUrZ_UQCyNuOQ5Fe8rEmykSP3teIz7M');">
                    </div>
                    <div class="flex-1 min-w-0">
                        <div class="flex justify-between items-center mb-1">
                            <h3 class="text-sm font-medium text-text-main dark:text-white truncate">ليلى خالد</h3>
                            <span class="text-[10px] text-gray-400">منذ 3 أيام</span>
                        </div>
                        <p class="text-xs text-text-secondary truncate">+966 54 321 0987</p>
                    </div>
                </div>
                <div
                    class="p-3 rounded-xl bg-white dark:bg-surface-dark hover:bg-gray-50 dark:hover:bg-gray-800 cursor-pointer flex items-center gap-4 transition-colors border border-transparent hover:border-gray-200 dark:hover:border-gray-700">
                    <div
                        class="h-12 w-12 rounded-full bg-primary-light text-primary flex items-center justify-center font-bold text-lg font-serif">
                        م
                    </div>
                    <div class="flex-1 min-w-0">
                        <div class="flex justify-between items-center mb-1">
                            <h3 class="text-sm font-medium text-text-main dark:text-white truncate">منى سعيد</h3>
                            <span class="text-[10px] text-gray-400">منذ أسبوع</span>
                        </div>
                        <p class="text-xs text-text-secondary truncate">+966 56 777 8888</p>
                    </div>
                </div>
            </div>
            <div class="p-4 border-t border-gray-100 dark:border-gray-800 bg-white dark:bg-surface-dark">
                <button
                    class="w-full flex items-center justify-center gap-2 bg-gradient-luxury text-white h-11 rounded-xl hover:shadow-lg hover:shadow-primary/30 transition-all duration-300 group">
                    <span class="material-symbols-outlined text-xl group-hover:rotate-90 transition-transform">add</span>
                    <span class="font-bold text-sm">إضافة عميل جديد</span>
                </button>
            </div>
        </div>
        <div class="flex-1 overflow-y-auto bg-background-light dark:bg-background-dark p-6 lg:p-8">
            <div class="max-w-6xl mx-auto space-y-8">
                <div
                    class="bg-white dark:bg-surface-dark rounded-2xl p-6 shadow-elegant flex flex-wrap gap-6 items-start justify-between relative overflow-hidden">
                    <div class="absolute top-0 right-0 w-32 h-32 bg-primary/5 rounded-bl-full pointer-events-none"></div>
                    <div class="flex gap-6 relative z-10">
                        <div class="relative">
                            <div class="h-28 w-28 rounded-full bg-cover bg-center border-[3px] border-white dark:border-surface-dark shadow-lg ring-1 ring-gray-100 dark:ring-gray-700"
                                data-alt="Large profile picture of Sarah"
                                style="background-image: url('https://lh3.googleusercontent.com/aida-public/AB6AXuAS_ZIbTjxgkf5dZkhhOjJSLGxgndrQnr4iWZLt3uukIy9GLDYf0mq9fyYrkMtsopxdIXzM_BMNDWNHvuEfRtkOtysSOOqQ2s5yNaZQvJVidV0nWyW9YBemtf-Q6HgDz9Myk7ccERZ9oiHriCrUk39FBUFvs7sQOMy4Yt61xDJFFfV3HWU_aySfrRnCGcbOo7WAm4gWvDlpF10fQBbfhMzzPoAPhR7eNLUZQzY9uFEAmuRS9Bcqbn6yWGOC2x7-APZrRd6ZDbIW8hA');">
                            </div>
                            <div class="absolute bottom-1 right-1 bg-green-500 h-6 w-6 rounded-full border-[3px] border-white dark:border-surface-dark flex items-center justify-center"
                                title="متصل">
                                <span class="block h-1.5 w-1.5 bg-white rounded-full"></span>
                            </div>
                        </div>
                        <div class="flex flex-col gap-1.5 py-1">
                            <div class="flex items-center gap-3">
                                <h1 class="text-2xl font-bold text-text-main dark:text-white font-serif">سارة محمد</h1>

                            </div>
                            <p class="text-text-secondary flex items-center gap-1 text-sm">
                                <span class="material-symbols-outlined text-lg text-primary/70">location_on</span>
                                الرياض، حي النخيل
                            </p>
                            <div class="flex gap-2 mt-3">
                                <button
                                    class="px-4 py-1.5 bg-gray-50 dark:bg-gray-800 border border-gray-200 dark:border-gray-700 hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg text-xs font-semibold text-text-main dark:text-gray-300 transition-colors flex items-center gap-1.5">
                                    <span class="material-symbols-outlined text-sm">edit</span> تعديل
                                </button>

                            </div>
                        </div>
                    </div>
                    <div
                        class="flex gap-6 self-center bg-gray-50 dark:bg-gray-800/50 p-3 rounded-xl border border-gray-100 dark:border-gray-700/50">
                        <div class="flex flex-col items-center px-4">
                            <span class="text-xs text-text-secondary mb-1">تاريخ التسجيل</span>
                            <span class="text-sm font-semibold text-text-main dark:text-gray-200">01 يناير 2023</span>
                        </div>
                        <div class="w-px bg-gray-200 dark:bg-gray-700 h-8 self-center"></div>
                        <div class="flex flex-col items-center px-4">
                            <span class="text-xs text-text-secondary mb-1">آخر زيارة</span>
                            <span class="text-sm font-semibold text-text-main dark:text-gray-200">منذ يومين</span>
                        </div>
                        <div class="w-px bg-gray-200 dark:bg-gray-700 h-8 self-center"></div>
                        <div class="flex flex-col items-center px-4">
                            <span class="text-xs text-text-secondary mb-1">عدد الزيارات</span>
                            <span class="text-lg font-bold text-primary">12</span>
                        </div>
                        <div class="flex flex-col items-center px-4">
                            <span class="text-xs text-text-secondary mb-1">إجمالي الحجوزات</span>
                            <span class="text-lg font-bold text-primary">15</span>
                        </div>
                        <div class="flex flex-col items-center px-4">
                            <span class="text-xs text-text-secondary mb-1">إجمالي المدفوع</span>
                            <span class="text-lg font-bold text-primary">1500 ريال</span>
                        </div>
                    </div>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                    <div class="space-y-6">
                        <div
                            class="bg-white dark:bg-surface-dark rounded-2xl p-6 shadow-soft border border-gray-50 dark:border-gray-800">
                            <h3
                                class="font-bold text-lg text-text-main dark:text-white mb-5 flex items-center gap-2 pb-3 border-b border-gray-100 dark:border-gray-800">
                                <span
                                    class="w-8 h-8 rounded-lg bg-primary/10 flex items-center justify-center text-primary">
                                    <span class="material-symbols-outlined text-lg">person</span>
                                </span>
                                بيانات الاتصال
                            </h3>
                            <div class="space-y-5">
                                <div class="flex items-center justify-between group">
                                    <div class="flex items-center gap-3">
                                        <div
                                            class="h-9 w-9 rounded-full bg-gray-50 text-gray-500 flex items-center justify-center group-hover:bg-green-50 group-hover:text-green-600 transition-colors">
                                            <span class="material-symbols-outlined text-lg">call</span>
                                        </div>
                                        <div class="flex flex-col">
                                            <span class="text-xs text-text-secondary">رقم الهاتف</span>
                                            <span class="text-sm font-medium dark:text-gray-200 font-sans" dir="ltr">+966 55
                                                123 4567</span>
                                        </div>
                                    </div>
                                    <button class="text-gray-300 hover:text-primary transition-colors"><span
                                            class="material-symbols-outlined text-sm">content_copy</span></button>
                                </div>
                                <div class="flex items-center justify-between group">
                                    <div class="flex items-center gap-3">
                                        <div
                                            class="h-9 w-9 rounded-full bg-gray-50 text-gray-500 flex items-center justify-center group-hover:bg-blue-50 group-hover:text-blue-600 transition-colors">
                                            <span class="material-symbols-outlined text-lg">mail</span>
                                        </div>
                                        <div class="flex flex-col">
                                            <span class="text-xs text-text-secondary">البريد الإلكتروني</span>
                                            <span class="text-sm font-medium dark:text-gray-200">sara@example.com</span>
                                        </div>
                                    </div>
                                    <button class="text-gray-300 hover:text-primary transition-colors"><span
                                            class="material-symbols-outlined text-sm">content_copy</span></button>
                                </div>
                                <div class="flex items-center justify-between group">
                                    <div class="flex items-center gap-3">
                                        <div
                                            class="h-9 w-9 rounded-full bg-gray-50 text-gray-500 flex items-center justify-center group-hover:bg-purple-50 group-hover:text-purple-600 transition-colors">
                                            <span class="material-symbols-outlined text-lg">cake</span>
                                        </div>
                                        <div class="flex flex-col">
                                            <span class="text-xs text-text-secondary">تاريخ الميلاد</span>
                                            <span class="text-sm font-medium dark:text-gray-200">15 مارس 1990</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="md:col-span-2 space-y-6">
                        <div
                            class="bg-white dark:bg-surface-dark rounded-2xl p-6 shadow-soft border border-gray-50 dark:border-gray-800">
                            <div class="flex justify-between items-start mb-6">
                                <div>
                                    <h3 class="font-bold text-lg text-text-main dark:text-white flex items-center gap-2">
                                        <span
                                            class="w-8 h-8 rounded-lg bg-yellow-50 flex items-center justify-center text-yellow-600">
                                            <span class="material-symbols-outlined fill-1">diamond</span>
                                        </span>
                                        نقاط الولاء
                                    </h3>
                                    <p class="text-sm text-text-secondary mt-2 pr-10">المستوى الحالي: <span
                                            class="font-bold text-primary">الذهبي</span></p>
                                </div>
                                <div class="text-right bg-gray-50 dark:bg-gray-800 px-4 py-2 rounded-xl">
                                    <span class="block text-2xl font-black text-primary dark:text-white">1,200</span>
                                    <span class="text-xs text-text-secondary font-medium uppercase tracking-wider">نقطة
                                        متاحة</span>
                                </div>
                            </div>
                            <div class="mb-4 bg-gray-50 dark:bg-gray-800/50 p-4 rounded-xl">
                                <div class="flex justify-between text-xs mb-2 font-medium">
                                    <span class="text-primary font-bold">1200 نقطة</span>
                                    <span class="text-gray-400">2000 للبلاتيني</span>
                                </div>
                                <div
                                    class="w-full h-3 bg-gray-200 dark:bg-gray-700 rounded-full overflow-hidden shadow-inner">
                                    <div
                                        class="h-full bg-gradient-to-r from-yellow-400 to-yellow-600 w-[60%] rounded-full shadow-sm relative overflow-hidden">
                                        <div class="absolute top-0 left-0 bottom-0 right-0 bg-white/20 animate-pulse"></div>
                                    </div>
                                </div>
                                <p class="text-xs text-gray-500 mt-2 text-left">تبقى 800 نقطة للوصول للمستوى التالي</p>
                            </div>
                            <div class="flex justify-end">
                                <button
                                    class="text-sm text-white bg-primary hover:bg-primary-dark px-4 py-2 rounded-lg font-medium transition-colors shadow-sm">استبدال
                                    النقاط</button>
                            </div>
                        </div>
                        <div
                            class="bg-white dark:bg-surface-dark rounded-2xl shadow-soft overflow-hidden border border-gray-50 dark:border-gray-800">
                            <div class="flex border-b border-gray-100 dark:border-gray-800 px-2 pt-2 gap-1">
                                <button
                                    class="px-6 py-4 text-sm font-bold text-primary border-b-2 border-primary bg-primary/5 dark:bg-primary/10 rounded-t-lg transition-colors">سجل
                                    الحجوزات</button>
                                <button
                                    class="px-6 py-4 text-sm font-medium text-text-secondary hover:text-text-main dark:text-gray-400 dark:hover:text-white hover:bg-gray-50 dark:hover:bg-gray-800 rounded-t-lg transition-colors">سجل
                                    التواصل</button>
                                <button
                                    class="px-6 py-4 text-sm font-medium text-text-secondary hover:text-text-main dark:text-gray-400 dark:hover:text-white hover:bg-gray-50 dark:hover:bg-gray-800 rounded-t-lg transition-colors">المواعيد
                                    السابقة</button>
                            </div>
                            <div class="p-0">
                                <table class="w-full text-right">
                                    <thead
                                        class="bg-gray-50/80 dark:bg-gray-800/50 text-xs text-text-secondary font-medium uppercase tracking-wider">
                                        <tr>
                                            <th class="px-6 py-4 font-medium">رقم الحجز</th>
                                            <th class="px-6 py-4 font-medium">الخدمة</th>
                                            <th class="px-6 py-4 font-medium">الموظفة</th>
                                            <th class="px-6 py-4 font-medium">التاريخ والوقت</th>
                                            <th class="px-6 py-4 font-medium">الحالة</th>
                                        </tr>
                                    </thead>
                                    <tbody class="divide-y divide-gray-100 dark:divide-gray-800">
                                        <tr class="hover:bg-gray-50/50 dark:hover:bg-gray-800/30 transition-colors group">
                                            <td
                                                class="px-6 py-4 whitespace-nowrap text-sm font-bold text-primary font-mono">
                                                #1025</td>

                                            <td class="px-6 py-4 text-sm text-text-main dark:text-gray-300">خدمة صبغة شعر +
                                                عناية</td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-text-main">سارة
                                                حسن</td>

                                            <td class="px-6 py-4 whitespace-nowrap">
                                                <div class="flex flex-col">
                                                    <span class="text-sm font-medium text-text-main">24 أكتوبر, 2023</span>
                                                    <span class="text-xs text-text-muted">04:15 م - 05:15 م</span>
                                                </div>
                                            </td>
                                            <td class="px-6 py-4">
                                                <span
                                                    class="px-2.5 py-1 rounded-full text-xs font-medium bg-green-50 text-green-700 border border-green-100">مكتمل</span>
                                            </td>
                                        </tr>


                                        <!-- ----------- -->

                                        <!-- ----------- -->


                                    </tbody>
                                </table>
                                <div class="p-4 border-t border-gray-100 dark:border-gray-800 text-center bg-gray-50/30">
                                    <button
                                        class="text-sm text-primary font-bold hover:text-primary-dark hover:underline transition-colors flex items-center justify-center gap-1 mx-auto">
                                        عرض كل السجل <span class="material-symbols-outlined text-sm">arrow_downward</span>
                                    </button>
                                </div>
                            </div>
                        </div>
                        <div
                            class="bg-white dark:bg-surface-dark rounded-2xl p-6 shadow-soft border border-gray-50 dark:border-gray-800">
                            <h3 class="font-bold text-lg text-text-main dark:text-white mb-6 flex items-center gap-2">
                                <span class="w-8 h-8 rounded-lg bg-blue-50 flex items-center justify-center text-blue-600">
                                    <span class="material-symbols-outlined text-lg">forum</span>
                                </span>
                                آخر التواصل
                            </h3>
                            <div class="relative border-r-2 border-gray-100 dark:border-gray-700 mr-3.5 space-y-8 pr-8">
                                <div class="relative">
                                    <div
                                        class="absolute -right-[41px] top-1.5 h-4 w-4 rounded-full bg-green-500 ring-4 ring-white dark:ring-surface-dark shadow-sm">
                                    </div>
                                    <div class="flex justify-between items-start mb-2">
                                        <div>
                                            <p class="text-sm font-bold text-text-main dark:text-gray-200">رسالة تذكير
                                                بالموعيد</p>
                                            <p class="text-xs text-text-secondary mt-0.5 flex items-center gap-1">
                                                <span class="material-symbols-outlined text-[10px]">check_circle</span> تم
                                                الإرسال عبر واتساب
                                            </p>
                                        </div>
                                        <span
                                            class="text-[10px] font-medium text-text-secondary bg-gray-100 dark:bg-gray-800 px-2.5 py-1 rounded-full border border-gray-200 dark:border-gray-700">أمس
                                            10:00 ص</span>
                                    </div>
                                    <div
                                        class="p-4 bg-gray-50 dark:bg-gray-800/50 rounded-xl text-sm text-text-main dark:text-gray-300 border border-gray-100 dark:border-gray-700/50 relative">
                                        <span
                                            class="absolute -right-2 top-4 h-4 w-4 bg-gray-50 dark:bg-gray-800/50 rotate-45 border-t border-r border-gray-100 dark:border-gray-700/50"></span>
                                        مرحباً سارة، نذكرك بموعدك غداً الساعة 4:00 مساءً مع خبيرة الشعر منى.
                                    </div>
                                </div>
                                <div class="relative">
                                    <div
                                        class="absolute -right-[41px] top-1.5 h-4 w-4 rounded-full bg-blue-500 ring-4 ring-white dark:ring-surface-dark shadow-sm">
                                    </div>
                                    <div class="flex justify-between items-start">
                                        <div>
                                            <p class="text-sm font-bold text-text-main dark:text-gray-200">عرض خاص - عيد
                                                ميلاد</p>
                                            <p class="text-xs text-text-secondary mt-0.5">تم الإرسال عبر البريد الإلكتروني
                                            </p>
                                        </div>
                                        <span
                                            class="text-[10px] font-medium text-text-secondary bg-gray-100 dark:bg-gray-800 px-2.5 py-1 rounded-full border border-gray-200 dark:border-gray-700">15
                                            مارس 2023</span>
                                    </div>
                                </div>
                            </div>
                            <div class="mt-6 flex gap-3">
                                <button
                                    class="flex-1 py-2.5 border border-gray-200 dark:border-gray-700 rounded-xl text-sm font-bold text-gray-700 dark:text-gray-300 hover:bg-green-50 hover:border-green-200 hover:text-green-700 dark:hover:bg-green-900/20 transition-all flex items-center justify-center gap-2 group">
                                    <span
                                        class="material-symbols-outlined text-green-600 text-lg group-hover:scale-110 transition-transform">chat</span>
                                    واتساب
                                </button>
                                <button
                                    class="flex-1 py-2.5 border border-gray-200 dark:border-gray-700 rounded-xl text-sm font-bold text-gray-700 dark:text-gray-300 hover:bg-blue-50 hover:border-blue-200 hover:text-blue-700 dark:hover:bg-blue-900/20 transition-all flex items-center justify-center gap-2 group">
                                    <span
                                        class="material-symbols-outlined text-blue-600 text-lg group-hover:scale-110 transition-transform">mail</span>
                                    بريد إلكتروني
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection