@extends('layouts.app')

@section('title', 'التنبيهات')

@section('content')

    <!-- Page Header -->
    <header class="p-4  md:px-12">
        <div class=" mx-auto flex flex-col gap-6">
            <div class="flex items-center gap-2 text-sm">
                <a class="text-text-secondary hover:text-primary transition-colors" href="#">الرئيسية</a>
                <span class="text-text-tertiary text-xs material-symbols-outlined rotate-180">chevron_right</span>
                <span class="text-primary font-bold">التنبيهات</span>
            </div>
            <div class="flex flex-wrap justify-between items-end gap-4">
                <div class="flex flex-col gap-2">
                    <h2 class="text-text-main text-3xl md:text-4xl font-extrabold tracking-tight">التنبيهات</h2>
                    <div class="flex items-center gap-2 text-text-muted">
                        <span class="material-symbols-outlined text-[18px]">calendar_today</span>
                        <p class="text-sm font-medium">الخميس، 25 ديسمبر 2025</p>
                    </div>
                </div>
                <div class="flex gap-3">
                    <!-- Quick Stats Summary -->
                    <div class="flex gap-4">
                        <div
                            class="bg-white p-4 rounded-2xl shadow-sm border border-[#f1e9e9] flex items-center gap-4 min-w-[160px]">
                            <div class="size-10 rounded-full bg-primary/10 flex items-center justify-center text-primary">
                                <span class="material-symbols-outlined">event_available</span>
                            </div>
                            <div>
                                <p class="text-xs text-text-muted font-bold">المواعيد اليوم</p>
                                <p class="text-2xl font-black text-text-main">5</p>
                            </div>
                        </div>
                        <div
                            class="bg-white p-4 rounded-2xl shadow-sm border border-[#f1e9e9] flex items-center gap-4 min-w-[160px]">
                            <div class="size-10 rounded-full bg-pink-50 flex items-center justify-center text-pink-600">
                                <span class="material-symbols-outlined">cake</span>
                            </div>
                            <div>
                                <p class="text-xs text-text-muted font-bold">أعياد الميلاد</p>
                                <p class="text-2xl font-black text-text-main">3</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>
    <!-- end page header -->
    <div class="flex-1 overflow-y-auto p-4 md:p-8 md:px-12 scroll-smooth">

        <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
            <!-- Appointments Section -->
            <div class="bg-white rounded-2xl shadow-sm border border-[#f1e9e9] flex flex-col overflow-hidden h-fit">
                <div class="p-6 border-b border-[#f1e9e9] flex items-center justify-between bg-white">
                    <div>
                        <h3 class="text-lg font-bold text-text-main flex items-center gap-2">
                            المواعيد اليومية
                            <span class="bg-primary/10 text-primary text-xs px-2 py-0.5 rounded-full">5</span>
                        </h3>
                        <p class="text-xs text-text-muted mt-1">قائمة المواعيد المؤكدة لهذا اليوم</p>
                    </div>
                    <button
                        class="flex items-center gap-2 bg-primary text-white px-4 py-2 rounded-lg text-sm font-bold hover:bg-[#5e1717] transition-colors shadow-lg shadow-primary/20">
                        <span class="material-symbols-outlined text-[18px]">chat</span>
                        <span>إرسال تذكير للكل</span>
                    </button>
                </div>
                <div class="flex flex-col">
                    <!-- Item 1 -->
                    <div
                        class="group flex items-center justify-between p-5 hover:bg-[#fbf9f9] border-b border-[#f1e9e9] last:border-0 transition-colors">
                        <div class="flex items-center gap-4">
                            <div class="relative">
                                <div class="bg-center bg-no-repeat bg-cover rounded-full size-12 border border-[#f1e9e9]"
                                    data-alt="Client portrait woman short hair"
                                    style='background-image: url("https://lh3.googleusercontent.com/aida-public/AB6AXuAc2ko5ReBoRgfXq5FfEUYEynOsX50ovUDRY0gzl7ELSyUM609_pGZ7EGlQC8fURsmIib-7Rripz62lDwAQlTsaMdeZIiGapkhUy9ppXJ2zGmNbiJP0IP8MBFlCPBr2tA6jMm871vQQb983FX1gmxxhTiYTUtWtCJ_ZUiUfx6arCs51sFMGJ2YxkyI-OyF8AXnztNqbe9jPtArMtRNlMNJP8zb1D7ZHtasgGb8rnnhFaI2dnB4UORHy4_mY6YUWYuHZUFdPQTwUT9I");'>
                                </div>
                                <div
                                    class="absolute -bottom-1 -right-1 bg-green-500 border-2 border-white size-3 rounded-full">
                                </div>
                            </div>
                            <div>
                                <h4 class="text-base font-bold text-text-main">منى عبدالله</h4>
                                <div class="flex items-center gap-2 mt-1">
                                    <span class="bg-gray-100 text-text-main text-xs px-2 py-0.5 rounded font-medium">قص
                                        وصبغة</span>
                                    <span class="text-text-muted text-xs flex items-center gap-1">
                                        <span class="material-symbols-outlined text-[12px]">schedule</span> 10:00 ص
                                    </span>
                                </div>
                            </div>
                        </div>
                        <button
                            class="size-9 rounded-full border border-gray-200 text-gray-400 hover:text-[#25D366] hover:border-[#25D366] hover:bg-green-50 flex items-center justify-center transition-all"
                            title="إرسال تذكير فردي">
                            <span class="material-symbols-outlined text-[20px]">chat</span>
                        </button>
                    </div>
                    <!-- Item 2 -->
                    <div
                        class="group flex items-center justify-between p-5 hover:bg-[#fbf9f9] border-b border-[#f1e9e9] last:border-0 transition-colors">
                        <div class="flex items-center gap-4">
                            <div class="relative">
                                <div class="bg-center bg-no-repeat bg-cover rounded-full size-12 border border-[#f1e9e9]"
                                    data-alt="Client portrait woman hijab"
                                    style='background-image: url("https://lh3.googleusercontent.com/aida-public/AB6AXuBEsIFF8hKGjo264eB3utut_6n-yIo6cmEApm5C45TM-KK18seD3v8TlfZo_w3PoSHN_XPDfWPfvDSqSwX6cGFjZ-eZ-hSxBt7-D_5xepuLGRlesexrPcTREdE38F3-LizmmE9wcjXMzTg0LWaZ0phshBG-VxOYlBkt68uLwRgfzPJcD6vCRT1B0xQ1w2QgXsyEzgCgo8pxWh1N_E4_Urb9skNVDoH3PojZJ4ZcXRqkCtrnu-NNLJ2pGWISnAq3WRJmrKNcp2Cp0o0");'>
                                </div>
                                <div
                                    class="absolute -bottom-1 -right-1 bg-yellow-500 border-2 border-white size-3 rounded-full">
                                </div>
                            </div>
                            <div>
                                <h4 class="text-base font-bold text-text-main">ليلى حسن</h4>
                                <div class="flex items-center gap-2 mt-1">
                                    <span class="bg-gray-100 text-text-main text-xs px-2 py-0.5 rounded font-medium">عناية
                                        بالبشرة</span>
                                    <span class="text-text-muted text-xs flex items-center gap-1">
                                        <span class="material-symbols-outlined text-[12px]">schedule</span> 11:30 ص
                                    </span>
                                </div>
                            </div>
                        </div>
                        <button
                            class="size-9 rounded-full border border-gray-200 text-gray-400 hover:text-[#25D366] hover:border-[#25D366] hover:bg-green-50 flex items-center justify-center transition-all"
                            title="إرسال تذكير فردي">
                            <span class="material-symbols-outlined text-[20px]">chat</span>
                        </button>
                    </div>
                    <!-- Item 3 -->
                    <div
                        class="group flex items-center justify-between p-5 hover:bg-[#fbf9f9] border-b border-[#f1e9e9] last:border-0 transition-colors">
                        <div class="flex items-center gap-4">
                            <div class="relative">
                                <div class="bg-center bg-no-repeat bg-cover rounded-full size-12 border border-[#f1e9e9]"
                                    data-alt="Client portrait woman curly hair"
                                    style='background-image: url("https://lh3.googleusercontent.com/aida-public/AB6AXuDvee21VPYheyKaRgYwOIDavg1wkRL1b6jZyCiv05qjpv-M4wJBv55xHXAYFsRgLX8n2AHNwBbYXWnS5UlWIuSIbi2c5k96l_Sb-bzo6P9SXBNIfz4_O_31IaCjNWW2INEULphanU6R0oUCUGBKMg0p_9-2weLeCYX4XWb2FubP2ULR67DQy-80m87M3N2ufu8fC_8d6R4UOWcoP0Oz7-4hA_gAfKoQ7RdVXbZSMyEoDASoiy8HHgjjEiTjuT8AgBWDHF2p7N2LzLU");'>
                                </div>
                                <div
                                    class="absolute -bottom-1 -right-1 bg-green-500 border-2 border-white size-3 rounded-full">
                                </div>
                            </div>
                            <div>
                                <h4 class="text-base font-bold text-text-main">نورة الزهراني</h4>
                                <div class="flex items-center gap-2 mt-1">
                                    <span class="bg-gray-100 text-text-main text-xs px-2 py-0.5 rounded font-medium">مكياج
                                        سهرة</span>
                                    <span class="text-text-muted text-xs flex items-center gap-1">
                                        <span class="material-symbols-outlined text-[12px]">schedule</span> 02:00 م
                                    </span>
                                </div>
                            </div>
                        </div>
                        <button
                            class="size-9 rounded-full border border-gray-200 text-gray-400 hover:text-[#25D366] hover:border-[#25D366] hover:bg-green-50 flex items-center justify-center transition-all"
                            title="إرسال تذكير فردي">
                            <span class="material-symbols-outlined text-[20px]">chat</span>
                        </button>
                    </div>
                    <!-- Item 4 -->
                    <div
                        class="group flex items-center justify-between p-5 hover:bg-[#fbf9f9] border-b border-[#f1e9e9] last:border-0 transition-colors">
                        <div class="flex items-center gap-4">
                            <div class="relative">
                                <div class="bg-center bg-no-repeat bg-cover rounded-full size-12 border border-[#f1e9e9]"
                                    data-alt="Client portrait minimalist"
                                    style='background-image: url("https://lh3.googleusercontent.com/aida-public/AB6AXuCauuOtc8kRJX1UrWxqlqCJOHgNW27tjzH2XPIOGAouJI6vk5rRMHxh18P5BGybANX614E7r3bGU0he6pxaE-b2m2J1cWe1mDt_Ro2jKmT64xKxDN0YLf97ZsPSaiN4hnbpXsvDsNKarnfGtN-7h0Dk7A8I-UJHQamLjNWaS9mVCfHyoASohjtJ8mIKZNNQ7WzCgHGeunZOw0qfswDDyQWCWYof1S2f2MbyTrwnmdBGac-HnX-bIdW0NL_ipIJR880Smsw7H-mwlxg");'>
                                </div>
                            </div>
                            <div>
                                <h4 class="text-base font-bold text-text-main">أمل سعيد</h4>
                                <div class="flex items-center gap-2 mt-1">
                                    <span class="bg-gray-100 text-text-main text-xs px-2 py-0.5 rounded font-medium">مانيكير
                                        وباديكير</span>
                                    <span class="text-text-muted text-xs flex items-center gap-1">
                                        <span class="material-symbols-outlined text-[12px]">schedule</span> 04:15 م
                                    </span>
                                </div>
                            </div>
                        </div>
                        <button
                            class="size-9 rounded-full border border-gray-200 text-gray-400 hover:text-[#25D366] hover:border-[#25D366] hover:bg-green-50 flex items-center justify-center transition-all"
                            title="إرسال تذكير فردي">
                            <span class="material-symbols-outlined text-[20px]">chat</span>
                        </button>
                    </div>
                </div>
                <div class="p-3 bg-gray-50 border-t border-[#f1e9e9] text-center">
                    <a class="text-sm font-bold text-primary hover:underline" href="#">عرض كل المواعيد</a>
                </div>
            </div>
            <!-- Birthdays Section -->
            <div class="bg-white rounded-2xl shadow-sm border border-[#f1e9e9] flex flex-col overflow-hidden h-fit">
                <div
                    class="p-6 border-b border-[#f1e9e9] flex items-center justify-between bg-[radial-gradient(ellipse_at_top_left,_var(--tw-gradient-stops))] from-pink-50 to-white">
                    <div>
                        <h3 class="text-lg font-bold text-text-main flex items-center gap-2">
                            أعياد ميلاد العملاء
                            <span class="bg-pink-100 text-pink-700 text-xs px-2 py-0.5 rounded-full">3</span>
                        </h3>
                        <p class="text-xs text-text-muted mt-1">قائمة العملاء الذين يحتفلون بيوم ميلادهم اليوم</p>
                    </div>
                    <button
                        class="flex items-center gap-2 bg-white text-text-main border border-gray-200 px-4 py-2 rounded-lg text-sm font-bold hover:bg-gray-50 hover:text-primary transition-colors">
                        <span class="material-symbols-outlined text-[18px] text-pink-500">celebration</span>
                        <span>إرسال تهنئة للكل</span>
                    </button>
                </div>
                <div class="flex flex-col">
                    <!-- Birthday Item 1 -->
                    <div
                        class="group flex items-center justify-between p-5 hover:bg-[#fbf9f9] border-b border-[#f1e9e9] last:border-0 transition-colors">
                        <div class="flex items-center gap-4">
                            <div class="bg-center bg-no-repeat bg-cover rounded-full size-12 border-2 border-pink-100"
                                data-alt="Client portrait birthday girl"
                                style='background-image: url("https://lh3.googleusercontent.com/aida-public/AB6AXuD7BDeGHR3C4K13gibV84MsaCW37GcadRB2Yy1f9SQDSPvIqRqghk_BGpJY--xRXMUk8-RYWPKVSm4HDqrBanYTs39WoDk4ggkbIcSZwXvRwpHepxNGFL6_wflztkWeM-r8PrSCGlaP2hlthypvU6S0W55YgGxRGQ-7Q28f0atngm9Fj1byK36D2JQgM3lJv6_hm5Bbu9XFzzgsPp3Sb_aUEeo95Xa2lslpugJc6FAzXObSs2362Ij770kRG4lz0oQW3KY8-FHQ-wY");'>
                            </div>
                            <div>
                                <h4 class="text-base font-bold text-text-main">عبير محمد</h4>
                                <div class="flex items-center gap-2 mt-1">
                                    <span class="text-text-muted text-xs">32 سنة</span>
                                </div>
                            </div>
                        </div>
                        <button
                            class="group/btn flex items-center gap-2 bg-white border border-gray-200 text-text-muted px-3 py-1.5 rounded-lg text-xs font-bold hover:bg-green-50 hover:text-green-600 hover:border-green-200 transition-colors">
                            <span class="material-symbols-outlined text-[16px]">chat</span>
                            تهنئة
                        </button>
                    </div>
                    <!-- Birthday Item 2 -->
                    <div
                        class="group flex items-center justify-between p-5 hover:bg-[#fbf9f9] border-b border-[#f1e9e9] last:border-0 transition-colors">
                        <div class="flex items-center gap-4">
                            <div class="bg-center bg-no-repeat bg-cover rounded-full size-12 border-2 border-pink-100"
                                data-alt="Client portrait happy woman"
                                style='background-image: url("https://lh3.googleusercontent.com/aida-public/AB6AXuBaXiFLlzAl1tTrha4SLkOUWRL2FOoOXLvqKSVP8XcVSsi5kCanwAeQVzeeC0YbJp6MqqzOQV4eb2OPCfT2qyUgAmGFZhx1ABlp5p3bSpRb1mlkm7k4_z0_u-PRsTIe9S3VQdFoFkbLKCJSfw160qLZU7RDayPs6CyverBnrMh3U_n0BR-WkqhpmVfwZINt0_nKdiZHNTcZzO6ytq8LyVJacbsgdBAn_oi6ju7-KswOkwScA2iVx_ECv22EKH5fRcx8jsoCJ6GSoWo");'>
                            </div>
                            <div>
                                <h4 class="text-base font-bold text-text-main">سمية خالد</h4>
                                <div class="flex items-center gap-2 mt-1">

                                    <span class="text-text-muted text-xs">25 سنة</span>
                                </div>
                            </div>
                        </div>
                        <button
                            class="group/btn flex items-center gap-2 bg-white border border-gray-200 text-text-muted px-3 py-1.5 rounded-lg text-xs font-bold hover:bg-green-50 hover:text-green-600 hover:border-green-200 transition-colors">
                            <span class="material-symbols-outlined text-[16px]">chat</span>
                            تهنئة
                        </button>
                    </div>
                    <!-- Birthday Item 3 -->
                    <div
                        class="group flex items-center justify-between p-5 hover:bg-[#fbf9f9] border-b border-[#f1e9e9] last:border-0 transition-colors">
                        <div class="flex items-center gap-4">
                            <div class="bg-center bg-no-repeat bg-cover rounded-full size-12 border-2 border-pink-100"
                                data-alt="Client portrait elegant woman"
                                style='background-image: url("https://lh3.googleusercontent.com/aida-public/AB6AXuDlVoA6S6x-lcOMSVQCiWVLGd1tpxgR7g9AfSmMIf9_VcepQiH73MmrCVJXkX6J573JCfl7kzg8Bs8kMrMw-eVZxMaZh-Qy_5YTIlygCfgwgT408sKKWSvmDlUV0HjKmMBZkaQPmK4AYVwQYEZZFDtp8fv8Zhf_VRCqY7vRPwAZyS_vto7pDVvNeaF_3r5MXSq3nNKVeDngBSq_aWOeaZv3Mh62lsI9Ln2PmdMSHzM5pMi9rin3EpQEhNL-Mnc3Bwo3e-B-134A_94");'>
                            </div>
                            <div>
                                <h4 class="text-base font-bold text-text-main">رنا الفهد</h4>
                                <div class="flex items-center gap-2 mt-1">
                                    <span class="text-text-muted text-xs">29 سنة</span>
                                </div>
                            </div>
                        </div>
                        <button
                            class="group/btn flex items-center gap-2 bg-white border border-gray-200 text-text-muted px-3 py-1.5 rounded-lg text-xs font-bold hover:bg-green-50 hover:text-green-600 hover:border-green-200 transition-colors">
                            <span class="material-symbols-outlined text-[16px]">chat</span>
                            تهنئة
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>


@endsection