@extends('layouts.app')

@section('title', 'إدارة أقسام الخدمات')

@section('content')

    <!-- Page Header -->
    <header class="p-4  md:px-12">
        <div class=" mx-auto flex flex-col gap-6">
            <div class="flex items-center gap-2 text-sm">
                <a class="text-text-secondary hover:text-primary transition-colors" href="#">الرئيسية</a>
                <span class="text-text-tertiary text-xs material-symbols-outlined rotate-180">chevron_right</span>
                <span class="text-text-secondary hover:text-primary transition-color">الخدمات</span>
                <span class="text-text-tertiary text-xs material-symbols-outlined rotate-180">chevron_right</span>
                <span class="text-primary font-bold">تصنيفات الخدمات</span>
            </div>
            <div class="flex flex-wrap justify-between items-end gap-4">
                <div class="flex flex-col gap-2">
                    <h2 class="text-text-main text-3xl md:text-4xl font-extrabold tracking-tight">تصنيفات الخدمات</h2>
                    <p class="text-text-secondary text-base max-w-2xl font-medium">إدارة أقسام الخدمات الكاملة الخاصة
                        بالمركز.
                    </p>
                </div>
                <div class="flex gap-3">
                    <button
                        class="px-5 py-2.5 rounded-lg bg-primary text-white font-bold text-sm hover:bg-primary/90 transition-colors shadow-md flex items-center gap-2">
                        <span class="material-symbols-outlined text-[20px]">add</span>
                        إضافة قسم جديد
                    </button>
                </div>
            </div>
        </div>
    </header>
    <!-- end page header -->

    <div class="flex-1 overflow-y-auto p-4 md:p-8 md:px-12 scroll-smooth">




        {{-- Filters --}}
        <div class="bg-white dark:bg-[#201c1c] border border-gray-200 dark:border-gray-700 rounded-xl my-5 p-5">
            <div class="flex flex-col md:flex-row gap-4">
                <div class="flex-1">
                    <label class="block text-sm font-medium mb-2 text-gray-700 dark:text-gray-300">
                        بحث
                    </label>
                    <div class="relative">
                        <input type="text" placeholder="بحث عن قسم..."
                            class="w-full h-12 rounded-lg bg-gray-50 dark:bg-gray-800 border border-gray-200 dark:border-gray-700 px-4 pr-10 focus:border-primary focus:ring-primary text-sm">
                        <span class="material-symbols-outlined absolute left-3 top-3 text-gray-400">search</span>
                    </div>
                </div>

                <div class="w-full md:w-48">
                    <label class="block text-sm font-medium mb-2 text-gray-700 dark:text-gray-300">
                        الحالة
                    </label>
                    <select
                        class="w-full h-12 rounded-lg bg-gray-50 dark:bg-gray-800 border border-gray-200 dark:border-gray-700 px-4 focus:border-primary focus:ring-primary text-sm">
                        <option>عرض الكل</option>
                        <option>نشط</option>
                        <option>غير نشط</option>
                    </select>
                </div>
            </div>
        </div>

        {{-- Table --}}
        <div
            class="bg-white dark:bg-[#201c1c] border border-gray-200 dark:border-gray-700 rounded-xl overflow-hidden shadow-sm">
            <div class="overflow-x-auto">
                <table class="w-full text-right">
                    <thead class="bg-gray-50 dark:bg-gray-800 border-b border-gray-200 dark:border-gray-700">
                        <tr class="text-gray-500 text-sm">
                            <th class="px-6 py-4">الصورة</th>
                            <th class="px-6 py-4">اسم القسم</th>
                            <th class="px-6 py-4">الوصف</th>
                            <th class="px-6 py-4 text-center">الخدمات</th>
                            <th class="px-6 py-4 text-center">الحالة</th>
                            <th class="px-6 py-4 text-end">الإجراءات</th>
                        </tr>
                    </thead>

                    <tbody class="divide-y divide-gray-200 dark:divide-gray-700">

                        {{-- Row --}}
                        <tr class="hover:bg-gray-50 dark:hover:bg-gray-800 transition">
                            <td class="px-6 py-4">
                                <div class="size-12 rounded-lg bg-cover bg-center border"
                                    style="background-image:url('https://lh3.googleusercontent.com/aida-public/AB6AXuAf82oCRrvfy6eiEVl4m02laIPCaPxSK4AhF2qDNlX8qPe-tIg2jcVXQkoEnbt8C3N75LtPLTjpnOdiFVlAYvuB5mdX2aTYng86qeVIm85G9dgxCokKbaUUoWBYQBlGjW2TY4uHTyauJcb7SdQWyypsbxr9X7Yy0woJ-gtpADYxCYqM8NnckQDJ942T9h8XbtnNlNutRcav8f_2McxN-LEZPtVEAis5UXg3bLbWfgrouf679X2v_AND9JjARC9HAFbityXIZ2i6hUY')">
                                </div>
                            </td>

                            <td class="px-6 py-4 font-bold text-gray-900 dark:text-white">
                                التصنيف الأول
                            </td>

                            <td class="px-6 py-4 text-gray-500 text-sm">
                                التصنيف الأول لخدمات الشعر
                            </td>

                            <td class="px-6 py-4 text-center">
                                <span class="px-3 py-1 rounded-full text-xs font-bold bg-gray-100 dark:bg-gray-700">
                                    12
                                </span>
                            </td>

                            <td class="px-6 py-4 text-center">
                                <span
                                    class="inline-flex items-center gap-1 px-3 py-1 rounded-full bg-emerald-100 text-emerald-700 text-xs font-bold">
                                    <span class="size-1.5 rounded-full bg-emerald-600"></span>
                                    نشط
                                </span>
                            </td>

                            <td class="px-6 py-4">
                                <div class="flex justify-end gap-2">
                                    <button class="size-9 rounded-lg hover:bg-primary/10 text-primary">
                                        <span class="material-symbols-outlined">edit</span>
                                    </button>
                                    <button class="size-9 rounded-lg hover:bg-red-100 text-red-500">
                                        <span class="material-symbols-outlined">delete</span>
                                    </button>
                                </div>
                            </td>
                        </tr>
                        {{-- Row --}}
                        <tr class="hover:bg-gray-50 dark:hover:bg-gray-800 transition">
                            <td class="px-6 py-4">
                                <div class="size-12 rounded-lg bg-cover bg-center border"
                                    style="background-image:url('https://lh3.googleusercontent.com/aida-public/AB6AXuAf82oCRrvfy6eiEVl4m02laIPCaPxSK4AhF2qDNlX8qPe-tIg2jcVXQkoEnbt8C3N75LtPLTjpnOdiFVlAYvuB5mdX2aTYng86qeVIm85G9dgxCokKbaUUoWBYQBlGjW2TY4uHTyauJcb7SdQWyypsbxr9X7Yy0woJ-gtpADYxCYqM8NnckQDJ942T9h8XbtnNlNutRcav8f_2McxN-LEZPtVEAis5UXg3bLbWfgrouf679X2v_AND9JjARC9HAFbityXIZ2i6hUY')">
                                </div>
                            </td>

                            <td class="px-6 py-4 font-bold text-gray-900 dark:text-white">
                                التصنيف الثاني
                            </td>

                            <td class="px-6 py-4 text-gray-500 text-sm">
                                التصنيف الثاني لخدمات الشعر
                            </td>

                            <td class="px-6 py-4 text-center">
                                <span class="px-3 py-1 rounded-full text-xs font-bold bg-gray-100 dark:bg-gray-700">
                                    5
                                </span>
                            </td>

                            <td class="px-6 py-4 text-center">
                                <span
                                    class="inline-flex items-center gap-1 px-3 py-1 rounded-full bg-emerald-100 text-emerald-700 text-xs font-bold">
                                    <span class="size-1.5 rounded-full bg-emerald-600"></span>
                                    نشط
                                </span>
                            </td>

                            <td class="px-6 py-4">
                                <div class="flex justify-end gap-2">
                                    <button class="size-9 rounded-lg hover:bg-primary/10 text-primary">
                                        <span class="material-symbols-outlined">edit</span>
                                    </button>
                                    <button class="size-9 rounded-lg hover:bg-red-100 text-red-500">
                                        <span class="material-symbols-outlined">delete</span>
                                    </button>
                                </div>
                            </td>
                        </tr>
                        {{-- Row --}}
                        <tr class="hover:bg-gray-50 dark:hover:bg-gray-800 transition">
                            <td class="px-6 py-4">
                                <div class="size-12 rounded-lg bg-cover bg-center border"
                                    style="background-image:url('https://lh3.googleusercontent.com/aida-public/AB6AXuAf82oCRrvfy6eiEVl4m02laIPCaPxSK4AhF2qDNlX8qPe-tIg2jcVXQkoEnbt8C3N75LtPLTjpnOdiFVlAYvuB5mdX2aTYng86qeVIm85G9dgxCokKbaUUoWBYQBlGjW2TY4uHTyauJcb7SdQWyypsbxr9X7Yy0woJ-gtpADYxCYqM8NnckQDJ942T9h8XbtnNlNutRcav8f_2McxN-LEZPtVEAis5UXg3bLbWfgrouf679X2v_AND9JjARC9HAFbityXIZ2i6hUY')">
                                </div>
                            </td>

                            <td class="px-6 py-4 font-bold text-gray-900 dark:text-white">
                                التصنيف الثالث
                            </td>

                            <td class="px-6 py-4 text-gray-500 text-sm">
                                التصنيف الثالث لخدمات الشعر
                            </td>

                            <td class="px-6 py-4 text-center">
                                <span class="px-3 py-1 rounded-full text-xs font-bold bg-gray-100 dark:bg-gray-700">
                                    10
                                </span>
                            </td>

                            <td class="px-6 py-4 text-center">
                                <span
                                    class="inline-flex items-center gap-1 px-3 py-1 rounded-full bg-emerald-100 text-emerald-700 text-xs font-bold">
                                    <span class="size-1.5 rounded-full bg-emerald-600"></span>
                                    نشط
                                </span>
                            </td>

                            <td class="px-6 py-4">
                                <div class="flex justify-end gap-2">
                                    <button class="size-9 rounded-lg hover:bg-primary/10 text-primary">
                                        <span class="material-symbols-outlined">edit</span>
                                    </button>
                                    <button class="size-9 rounded-lg hover:bg-red-100 text-red-500">
                                        <span class="material-symbols-outlined">delete</span>
                                    </button>
                                </div>
                            </td>
                        </tr>

                    </tbody>
                </table>
            </div>

            {{-- Pagination --}}
            <div class="flex items-center justify-between px-6 py-4 border-t border-gray-200 dark:border-gray-700 text-sm">
                <span class="text-gray-500">عرض 5 من 12 قسم</span>

                <div class="flex gap-2">
                    <button class="size-8 rounded-lg border text-gray-400">
                        <span class="material-symbols-outlined text-sm">chevron_right</span>
                    </button>
                    <button class="size-8 rounded-lg bg-primary text-white font-bold">1</button>
                    <button class="size-8 rounded-lg border">2</button>
                    <button class="size-8 rounded-lg border">3</button>
                    <button class="size-8 rounded-lg border">
                        <span class="material-symbols-outlined text-sm">chevron_left</span>
                    </button>
                </div>
            </div>
        </div>

    </div>


@endsection