@extends('layouts.app')

@section('title', 'إدارة الخدمات')

@section('content')

    <!-- Page Header -->
    <header class="p-4  md:px-12">
        <div class=" mx-auto flex flex-col gap-6">
            <div class="flex items-center gap-2 text-sm">
                <a class="text-text-secondary hover:text-primary transition-colors" href="#">الرئيسية</a>
                <span class="text-text-tertiary text-xs material-symbols-outlined rotate-180">chevron_right</span>
                <span class="text-text-secondary hover:text-primary transition-color">الخدمات</span>
                <span class="text-text-tertiary text-xs material-symbols-outlined rotate-180">chevron_right</span>
                <span class="text-primary font-bold">إدارة الخدمات</span>
            </div>
            <div class="flex flex-wrap justify-between items-end gap-4">
                <div class="flex flex-col gap-2">
                    <h2 class="text-text-main text-3xl md:text-4xl font-extrabold tracking-tight">إدارة الخدمات</h2>
                    <p class="text-text-secondary text-base max-w-2xl font-medium">إدارة الخدمات الكاملة الخاصة بالمركز.
                    </p>
                </div>
                <div class="flex gap-3">
                    <button
                        class="px-5 py-2.5 rounded-lg bg-primary text-white font-bold text-sm hover:bg-primary/90 transition-colors shadow-md flex items-center gap-2">
                        <span class="material-symbols-outlined text-[20px]">add</span>
                        إضافة خدمة جديدة
                    </button>
                </div>
            </div>
        </div>
    </header>
    <!-- end page header -->

    <div class="p-8">


        {{-- Stats --}}
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-10">
            <div class="bg-white p-6 rounded-2xl shadow border flex items-center gap-4">
                <div class="size-12 rounded-full bg-primary/10 text-primary flex items-center justify-center">
                    <span class="material-symbols-outlined">spa</span>
                </div>
                <div>
                    <p class="text-sm text-gray-500"> الخدمات</p>
                    <p class="text-2xl font-bold">42</p>
                </div>
            </div>

            <div class="bg-white p-6 rounded-2xl shadow border flex items-center gap-4">
                <div class="size-12 rounded-full bg-yellow-100 text-yellow-600 flex items-center justify-center">
                    <span class="material-symbols-outlined">category</span>
                </div>
                <div>
                    <p class="text-sm text-gray-500">التصنيفات</p>
                    <p class="text-2xl font-bold">8</p>
                </div>
            </div>

            <div class="bg-white p-6 rounded-2xl shadow border flex items-center gap-4">
                <div class="size-12 rounded-full bg-green-100 text-green-600 flex items-center justify-center">
                    <span class="material-symbols-outlined">trending_up</span>
                </div>
                <div>
                    <p class="text-sm text-gray-500">الأكثر طلبًا</p>
                    <p class="text-lg font-bold">العناية بالشعر</p>
                </div>
            </div>
        </div>

        {{-- Filters --}}
        <div
            class="bg-white p-4 rounded-xl border shadow mb-8 flex flex-col md:flex-row gap-4 items-center justify-between">
            <div class="relative w-full md:w-96">
                <span class="material-symbols-outlined absolute right-3 top-2.5 text-gray-400">search</span>
                <input type="text" placeholder="بحث عن خدمة..."
                    class="w-full pr-10 pl-4 py-2 rounded-lg border focus:border-primary focus:ring-0">
            </div>

            <div class="flex gap-3 overflow-x-auto">
                <button class="px-4 py-2 rounded-lg bg-primary text-white text-sm font-bold">الكل</button>
                <button class="px-4 py-2 rounded-lg bg-gray-100 text-gray-600 text-sm">التصنيف الأول </button>
                <button class="px-4 py-2 rounded-lg bg-gray-100 text-gray-600 text-sm">التصنيف الثاني</button>
                <button class="px-4 py-2 rounded-lg bg-gray-100 text-gray-600 text-sm">التصنيف الثالث</button>
                <button class="px-4 py-2 rounded-lg bg-gray-100 text-gray-600 text-sm">التصنيف الرابع</button>
            </div>
        </div>

        {{-- Services Grid --}}
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6">
            <div
                class="group bg-white rounded-2xl border border-neutral-100 overflow-hidden hover:shadow-soft hover:border-[#7b1f1f]/30 transition-all duration-300">
                <div class="relative h-48 overflow-hidden">
                    <img alt="Hair Treatment"
                        class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-500"
                        src="https://lh3.googleusercontent.com/aida-public/AB6AXuAMVXbOLMmK44bMehEMZkFSe4ObRnJ_FOKuSRFg68GtOtTkWKyAwxYUjW92aveNbENWF6195g3II4iSXUKDEXK2FMKefNSfSiTOkgnv86vvkvTl2ekVT0HOQxJxe1gXZ8AEegO714jAsNo1Ro-Jm-QcNjqCgUv8Msg2S73z3dz4L9_LfK5ea83tzomVYxGZ4cYSpabj3PCyzSxSZzF-rFb_LwXOo6Hqonvtgm7h1E26ksfBdKD3O75gKQzL3wTIC7zL-eOAxXWiFBg" />
                    <div class="absolute top-3 right-3">
                        <span
                            class="bg-white/90 backdrop-blur-sm px-2 py-1 rounded-md text-xs font-semibold text-[#7b1f1f] shadow-sm">الشعر</span>
                    </div>
                    <div class="absolute inset-0 bg-gradient-to-t from-black/60 to-transparent opacity-60"></div>
                </div>
                <div class="p-5">
                    <div class="flex justify-between items-start mb-2">
                        <h3 class="font-bold text-lg text-gray-800 group-hover:text-[#7b1f1f] transition-colors">قص شعر
                            وعلاج ملكي</h3>
                    </div>
                    <p class="text-gray-500 text-sm mb-4 line-clamp-2">جلسة شاملة لقص الشعر مع علاج بالكيراتين والزيوت
                        الطبيعية لإعادة الحيوية.</p>
                    <div class="flex items-center justify-between pt-4 border-t border-gray-50">
                        <div class="flex flex-col">
                            <span class="text-xs text-gray-400">السعر</span>
                            <span class="font-bold text-[#7b1f1f]">350 ر.س</span>
                        </div>
                        <div class="flex flex-col items-end">
                            <span class="text-xs text-gray-400">المدة</span>
                            <span class="font-medium text-gray-700">60 دقيقة</span>
                        </div>
                    </div>
                    <div class="mt-4 flex gap-2 opacity-0 group-hover:opacity-100 transition-opacity duration-300">
                        <button class="flex-1 btn-outline py-2 rounded-lg text-sm flex items-center justify-center gap-1">
                            <span class="material-symbols-outlined text-lg">edit</span>
                            تعديل
                        </button>
                        <button
                            class="w-10 flex items-center justify-center rounded-lg border border-red-100 text-red-500 hover:bg-red-50 transition-colors">
                            <span class="material-symbols-outlined text-lg">delete</span>
                        </button>
                    </div>
                </div>
            </div>
            <div
                class="group bg-white rounded-2xl border border-neutral-100 overflow-hidden hover:shadow-soft hover:border-[#7b1f1f]/30 transition-all duration-300">
                <div class="relative h-48 overflow-hidden">
                    <img alt="Manicure"
                        class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-500"
                        src="https://lh3.googleusercontent.com/aida-public/AB6AXuAMPSiN7o4CWrujqqItbh2NY70cwtYs17hvYV46Jjw0tI36X5lCaoBiOIGYTPHSFLCawwQrgJDdZ29xxmNXom9uoHQ_PScICRTGtGyCjG4cWh7mXYq_bBxXB_zc6-yidptss-IiPgfHkTL7RY636Ko_iXgWa1eTI54FrDkhsj_Ily9md67WMeHMogUHEL1YcjqcS9O9F88bgOqZYg9bvKMiX3vv73ri5PzFqrz43D7y77BhrkdnK4Psq9XEFL5Z587_sJvdoNm4srY" />
                    <div class="absolute top-3 right-3">
                        <span
                            class="bg-white/90 backdrop-blur-sm px-2 py-1 rounded-md text-xs font-semibold text-[#7b1f1f] shadow-sm">الأظافر</span>
                    </div>
                    <div class="absolute inset-0 bg-gradient-to-t from-black/60 to-transparent opacity-60"></div>
                </div>
                <div class="p-5">
                    <div class="flex justify-between items-start mb-2">
                        <h3 class="font-bold text-lg text-gray-800 group-hover:text-[#7b1f1f] transition-colors">مانيكير
                            وباديكير سبا</h3>
                    </div>
                    <p class="text-gray-500 text-sm mb-4 line-clamp-2">عناية كاملة بالأظافر مع مساج لليدين والقدمين باستخدام
                        كريمات فاخرة.</p>
                    <div class="flex items-center justify-between pt-4 border-t border-gray-50">
                        <div class="flex flex-col">
                            <span class="text-xs text-gray-400">السعر</span>
                            <span class="font-bold text-[#7b1f1f]">200 ر.س</span>
                        </div>
                        <div class="flex flex-col items-end">
                            <span class="text-xs text-gray-400">المدة</span>
                            <span class="font-medium text-gray-700">45 دقيقة</span>
                        </div>
                    </div>
                    <div class="mt-4 flex gap-2 opacity-0 group-hover:opacity-100 transition-opacity duration-300">
                        <button class="flex-1 btn-outline py-2 rounded-lg text-sm flex items-center justify-center gap-1">
                            <span class="material-symbols-outlined text-lg">edit</span>
                            تعديل
                        </button>
                        <button
                            class="w-10 flex items-center justify-center rounded-lg border border-red-100 text-red-500 hover:bg-red-50 transition-colors">
                            <span class="material-symbols-outlined text-lg">delete</span>
                        </button>
                    </div>
                </div>
            </div>
            <div
                class="group bg-white rounded-2xl border border-neutral-100 overflow-hidden hover:shadow-soft hover:border-[#7b1f1f]/30 transition-all duration-300">
                <div class="relative h-48 overflow-hidden">
                    <img alt="Makeup"
                        class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-500"
                        src="https://lh3.googleusercontent.com/aida-public/AB6AXuBwcmbHDoA_i5YvIOW5DkUQxycuos2ZwaCSln0iDBa0gkPFGTeXNIOqrDUntmVAYRbMaVO2nI2F93ux5EbiwulX6-bOM3VXZTVNboaZVZl6sDszUTDotILX7g14P5wf4PEUM8zfRctihOL4Cu9bqfh-h9qQguHwBobetOjlrVawRmRrYk2MORwam5etQd5JluJJ2igU9k9sxmHav0duqj-3tXpr0UhnrnYpbMy-vl_fUS74DI4sGonuHZK0K6jAOXMw2EudwFhQ_hM" />
                    <div class="absolute top-3 right-3">
                        <span
                            class="bg-white/90 backdrop-blur-sm px-2 py-1 rounded-md text-xs font-semibold text-[#7b1f1f] shadow-sm">المكياج</span>
                    </div>
                    <div class="absolute inset-0 bg-gradient-to-t from-black/60 to-transparent opacity-60"></div>
                </div>
                <div class="p-5">
                    <div class="flex justify-between items-start mb-2">
                        <h3 class="font-bold text-lg text-gray-800 group-hover:text-[#7b1f1f] transition-colors">مكياج سهرة
                            فاخر</h3>
                    </div>
                    <p class="text-gray-500 text-sm mb-4 line-clamp-2">مكياج احترافي للمناسبات الخاصة باستخدام ماركات عالمية
                        تناسب جميع البشرات.</p>
                    <div class="flex items-center justify-between pt-4 border-t border-gray-50">
                        <div class="flex flex-col">
                            <span class="text-xs text-gray-400">السعر</span>
                            <span class="font-bold text-[#7b1f1f]">500 ر.س</span>
                        </div>
                        <div class="flex flex-col items-end">
                            <span class="text-xs text-gray-400">المدة</span>
                            <span class="font-medium text-gray-700">90 دقيقة</span>
                        </div>
                    </div>
                    <div class="mt-4 flex gap-2 opacity-0 group-hover:opacity-100 transition-opacity duration-300">
                        <button class="flex-1 btn-outline py-2 rounded-lg text-sm flex items-center justify-center gap-1">
                            <span class="material-symbols-outlined text-lg">edit</span>
                            تعديل
                        </button>
                        <button
                            class="w-10 flex items-center justify-center rounded-lg border border-red-100 text-red-500 hover:bg-red-50 transition-colors">
                            <span class="material-symbols-outlined text-lg">delete</span>
                        </button>
                    </div>
                </div>
            </div>
            <div
                class="group bg-white rounded-2xl border border-neutral-100 overflow-hidden hover:shadow-soft hover:border-[#7b1f1f]/30 transition-all duration-300 opacity-75">
                <div class="relative h-48 overflow-hidden grayscale">
                    <img alt="Skin Care"
                        class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-500"
                        src="https://lh3.googleusercontent.com/aida-public/AB6AXuCpl6YlTV_nf-yWO4db9WPJWNFhOpTkCR9hH7BPrAVB3SX1F28lGkfs7MvtMK_WpXi8z_eU9kWzAQxFUVvTBEL1Sv3jZknIOg8QMTpJVxO8HvyYbafesqqVtkEjffDdbj--DIjgROYRwbPZJMCOzhX90RNqsLBtc4Woh4uyYAaoqAHxI4XN-BZycPqPMQhm2V_VmmCHwEHrVMTDikjlsT5bVwes62SusdiPDuKIaFtH56qjMAgVS_L4DuvA11hk6topUbyoliPl6II" />
                    <div class="absolute top-3 right-3">
                        <span
                            class="bg-gray-100/90 backdrop-blur-sm px-2 py-1 rounded-md text-xs font-semibold text-gray-500 shadow-sm">البشرة</span>
                    </div>
                    <div class="absolute top-3 left-3">

                    </div>
                </div>
                <div class="p-5">
                    <div class="flex justify-between items-start mb-2">
                        <h3 class="font-bold text-lg text-gray-600">تنظيف بشرة عميق</h3>
                    </div>
                    <p class="text-gray-400 text-sm mb-4 line-clamp-2">إزالة الشوائب والرؤوس السوداء مع ماسك الطين المغربي.
                    </p>
                    <div class="flex items-center justify-between pt-4 border-t border-gray-50">
                        <div class="flex flex-col">
                            <span class="text-xs text-gray-400">السعر</span>
                            <span class="font-bold text-gray-600">250 ر.س</span>
                        </div>
                        <div class="flex flex-col items-end">
                            <span class="text-xs text-gray-400">المدة</span>
                            <span class="font-medium text-gray-500">45 دقيقة</span>
                        </div>
                    </div>
                    <div class="mt-4 flex gap-2 opacity-0 group-hover:opacity-100 transition-opacity duration-300">
                        <button class="flex-1 btn-outline py-2 rounded-lg text-sm flex items-center justify-center gap-1">
                            <span class="material-symbols-outlined text-lg">edit</span>
                            تعديل
                        </button>
                        <button
                            class="w-10 flex items-center justify-center rounded-lg border border-red-100 text-red-500 hover:bg-red-50 transition-colors">
                            <span class="material-symbols-outlined text-lg">delete</span>
                        </button>
                    </div>
                </div>
            </div>
        </div>

        {{-- Pagination --}}
        <div class="flex items-center justify-between mt-10">
            <p class="text-sm text-gray-500">عرض 1-4 من 42 خدمة</p>

            <div class="flex gap-2">
                <button class="size-9 border rounded text-gray-400" disabled>
                    <span class="material-symbols-outlined text-sm">chevron_right</span>
                </button>
                <button class="size-9 bg-primary text-white rounded font-bold">1</button>
                <button class="size-9 border rounded">2</button>
                <button class="size-9 border rounded">3</button>
                <button class="size-9 border rounded">
                    <span class="material-symbols-outlined text-sm">chevron_left</span>
                </button>
            </div>
        </div>

    </div>

@endsection