@extends('layouts.app')

@section('title', 'الإشعارات')

@section('content')

    <header class="w-full px-6 py-8 pb-4">
        <div class=" mx-auto flex flex-col gap-6">
            <div class="flex items-center gap-2 text-sm">
                <a class="text-text-secondary hover:text-primary transition-colors" href="#">الرئيسية</a>
                <span class="text-text-tertiary text-xs material-symbols-outlined rotate-180">chevron_right</span>
                <a class="text-text-secondary hover:text-primary transition-colors" href="#">الإعدادات</a>
                <span class="text-text-tertiary text-xs material-symbols-outlined rotate-180">chevron_right</span>
                <span class="text-primary font-bold">الإشعارات والقوالب</span>
            </div>
            <div class="flex flex-wrap justify-between items-end gap-4">
                <div class="flex flex-col gap-2">
                    <h2 class="text-text-main text-3xl md:text-4xl font-extrabold tracking-tight">الإشعارات والقوالب</h2>
                    <p class="text-text-secondary text-base max-w-2xl font-medium">إدارة قوالب الرسائل النصية وتطبيق واتساب،
                        وجدولة التذكيرات التلقائية لعملائك.</p>
                </div>
                <button
                    class="flex items-center gap-2 cursor-pointer rounded-xl h-11 px-6 bg-white hover:bg-primary-light border border-border-medium hover:border-primary/30 text-primary text-sm font-bold transition-all shadow-sm hover:shadow-md">
                    <span class="material-symbols-outlined text-[20px]">send</span>
                    <span>إرسال رسالة تجريبية</span>
                </button>
            </div>
            <div class="border-b border-border-light mt-4">
                <div class="flex gap-8">
                    <button
                        class="flex items-center gap-2 border-b-[3px] border-primary text-primary pb-3 px-1 transition-all">
                        <span class="material-symbols-outlined text-[20px]">edit_note</span>
                        <span class="text-sm font-bold">قوالب الرسائل</span>
                    </button>
                    <button
                        class="flex items-center gap-2 border-b-[3px] border-transparent text-text-secondary hover:text-primary hover:border-primary-subtle pb-3 px-1 transition-all">
                        <span class="material-symbols-outlined text-[20px]">schedule</span>
                        <span class="text-sm font-medium">قواعد الإرسال الآلي</span>
                    </button>
                    <button
                        class="flex items-center gap-2 border-b-[3px] border-transparent text-text-secondary hover:text-primary hover:border-primary-subtle pb-3 px-1 transition-all">
                        <span class="material-symbols-outlined text-[20px]">history</span>
                        <span class="text-sm font-medium">سجل الرسائل</span>
                    </button>
                </div>
            </div>
        </div>
    </header>

    <div class="flex-1 overflow-y-auto p-4 md:p-8 md:px-12 scroll-smooth">
        <div class=" mx-auto grid grid-cols-1 lg:grid-cols-12 gap-8 pb-12">
            <div class="lg:col-span-4 flex flex-col gap-6">
                <h3 class="text-text-main text-lg font-bold mb-2 px-1">القوالب النشطة</h3>
                <div
                    class="group relative cursor-pointer overflow-hidden rounded-2xl bg-surface border-2 border-primary shadow-luxury p-5 transition-all">
                    <div class="flex justify-between items-start mb-3">
                        <div class="flex items-center gap-3">
                            <div class="size-10 rounded-full bg-primary/10 flex items-center justify-center text-primary">
                                <span class="material-symbols-outlined">check_circle</span>
                            </div>
                            <div class="flex flex-col">
                                <h4 class="text-text-main font-bold">تأكيد الحجز</h4>
                                <span
                                    class="text-xs text-green-600 font-bold bg-green-50 px-2 py-0.5 rounded-full w-fit mt-1 border border-green-100">نشط
                                    تلقائياً</span>
                            </div>
                        </div>
                    </div>
                    <p class="text-text-secondary text-sm line-clamp-2 leading-relaxed">أهلاً {اسم العميل}، نؤكد حجز موعدك
                        في صالون سوان يوم {التاريخ} الساعة {الوقت}. ننتظرك بكل حب!</p>
                </div>
                <div
                    class="group relative cursor-pointer overflow-hidden rounded-2xl bg-surface border border-border-light hover:border-primary/50 hover:shadow-lg transition-all p-5">
                    <div class="flex justify-between items-start mb-3">
                        <div class="flex items-center gap-3">
                            <div
                                class="size-10 rounded-full bg-gray-50 flex items-center justify-center text-text-tertiary group-hover:text-primary group-hover:bg-primary-light transition-colors">
                                <span class="material-symbols-outlined">notifications_active</span>
                            </div>
                            <div class="flex flex-col">
                                <h4 class="text-text-main font-bold group-hover:text-primary transition-colors">تذكير قبل
                                    الموعد</h4>
                                <span class="text-xs text-text-tertiary font-medium mt-1">قبل 24 ساعة</span>
                            </div>
                        </div>
                    </div>
                    <p class="text-text-secondary text-sm line-clamp-2 leading-relaxed">مرحباً {اسم العميل}، تذكير لطيف
                        بموعدك غداً الساعة {الوقت}. في حال الرغبة بالتأجيل يرجى التواصل معنا.</p>
                </div>
                <div
                    class="group relative cursor-pointer overflow-hidden rounded-2xl bg-surface border border-border-light hover:border-primary/50 hover:shadow-lg transition-all p-5">
                    <div class="flex justify-between items-start mb-3">
                        <div class="flex items-center gap-3">
                            <div
                                class="size-10 rounded-full bg-gray-50 flex items-center justify-center text-text-tertiary group-hover:text-primary group-hover:bg-primary-light transition-colors">
                                <span class="material-symbols-outlined">cancel</span>
                            </div>
                            <div class="flex flex-col">
                                <h4 class="text-text-main font-bold group-hover:text-primary transition-colors">إلغاء الموعد
                                </h4>
                                <span class="text-xs text-text-tertiary font-medium mt-1">يدوي</span>
                            </div>
                        </div>
                    </div>
                    <p class="text-text-secondary text-sm line-clamp-2 leading-relaxed">عزيزتي {اسم العميل}، تم إلغاء موعدك
                        المحدد بتاريخ {التاريخ} بناءً على طلبك. نأمل رؤيتك قريباً.</p>
                </div>
                <button
                    class="w-full py-4 rounded-xl border border-dashed border-primary/30 text-primary hover:bg-primary-light hover:border-primary transition-all flex items-center justify-center gap-2 group">
                    <span class="material-symbols-outlined group-hover:scale-110 transition-transform">add</span>
                    <span class="font-bold text-sm">إضافة قالب جديد</span>
                </button>
            </div>
            <div class="lg:col-span-8 flex flex-col gap-6">
                <div class="bg-surface rounded-2xl border border-border-light p-6 lg:p-8 shadow-luxury">
                    <div class="flex flex-wrap justify-between items-start gap-4 mb-6 border-b border-border-light pb-6">
                        <div>
                            <h3 class="text-text-main text-xl font-bold mb-1">تعديل قالب: تأكيد الحجز</h3>
                            <p class="text-text-secondary text-sm">يتم إرسال هذه الرسالة تلقائياً عند إنشاء حجز جديد.</p>
                        </div>
                        <div class="flex items-center gap-2 bg-gray-50 p-1.5 rounded-lg border border-border-light">
                            <button
                                class="px-4 py-1.5 rounded-md bg-white text-primary text-xs font-bold shadow-sm border border-border-light">SMS</button>
                            <button
                                class="px-4 py-1.5 rounded-md text-text-secondary hover:text-primary hover:bg-white/50 text-xs font-bold transition-all">WhatsApp</button>
                            <button
                                class="px-4 py-1.5 rounded-md text-text-secondary hover:text-primary hover:bg-white/50 text-xs font-bold transition-all">Email</button>
                        </div>
                    </div>
                    <div class="mb-4">
                        <label class="block text-text-tertiary text-xs font-bold mb-3 uppercase tracking-wider">المتغيرات
                            المتاحة (اضغط للإضافة)</label>
                        <div class="flex flex-wrap gap-2">
                            <button
                                class="px-3 py-1.5 rounded-lg bg-white hover:bg-primary-light border border-border-medium hover:border-primary/30 text-primary text-sm font-medium transition-colors flex items-center gap-1 shadow-sm">
                                <span class="material-symbols-outlined text-[16px]">person</span>
                                {اسم العميل}
                            </button>
                            <button
                                class="px-3 py-1.5 rounded-lg bg-white hover:bg-primary-light border border-border-medium hover:border-primary/30 text-primary text-sm font-medium transition-colors flex items-center gap-1 shadow-sm">
                                <span class="material-symbols-outlined text-[16px]">calendar_today</span>
                                {التاريخ}
                            </button>
                            <button
                                class="px-3 py-1.5 rounded-lg bg-white hover:bg-primary-light border border-border-medium hover:border-primary/30 text-primary text-sm font-medium transition-colors flex items-center gap-1 shadow-sm">
                                <span class="material-symbols-outlined text-[16px]">schedule</span>
                                {الوقت}
                            </button>
                            <button
                                class="px-3 py-1.5 rounded-lg bg-white hover:bg-primary-light border border-border-medium hover:border-primary/30 text-primary text-sm font-medium transition-colors flex items-center gap-1 shadow-sm">
                                <span class="material-symbols-outlined text-[16px]">spa</span>
                                {الخدمة}
                            </button>
                            <button
                                class="px-3 py-1.5 rounded-lg bg-white hover:bg-primary-light border border-border-medium hover:border-primary/30 text-primary text-sm font-medium transition-colors flex items-center gap-1 shadow-sm">
                                <span class="material-symbols-outlined text-[16px]">store</span>
                                {اسم الصالون}
                            </button>
                        </div>
                    </div>
                    <div class="relative mb-6 group">
                        <textarea
                            class="w-full bg-gray-50 text-text-main border border-border-medium rounded-xl p-4 focus:ring-2 focus:ring-primary focus:border-transparent transition-all resize-none text-base leading-relaxed placeholder-text-tertiary"
                            placeholder="اكتب نص الرسالة هنا..." rows="6">أهلاً {اسم العميل}، 
                                                نؤكد حجز موعدك في {اسم الصالون} يوم {التاريخ} الساعة {الوقت} لخدمة {الخدمة}. 
                                                ننتظرك بكل حب! 
                                                للمساعدة، يرجى الرد على هذه الرسالة.</textarea>
                        <div
                            class="absolute bottom-3 left-3 text-xs text-text-secondary bg-white/80 px-2 py-1 rounded shadow-sm border border-border-light">
                            <span class="font-bold text-primary">124</span> / 160 حرف (رسالة واحدة)
                        </div>
                    </div>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-8">
                        <div class="flex items-center justify-between bg-gray-50 p-4 rounded-xl border border-border-light">
                            <div class="flex flex-col gap-1">
                                <span class="text-text-main text-sm font-bold">الإرسال التلقائي</span>
                                <span class="text-text-secondary text-xs">إرسال فور إنشاء الحجز</span>
                            </div>
                            <label class="relative inline-flex items-center cursor-pointer">
                                <input checked="" class="sr-only peer" type="checkbox" value="" />
                                <div
                                    class="w-11 h-6 bg-gray-300 peer-focus:outline-none rounded-full peer peer-checked:after:translate-x-full rtl:peer-checked:after:-translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:start-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-primary">
                                </div>
                            </label>
                        </div>
                        <div class="flex items-center justify-between bg-gray-50 p-4 rounded-xl border border-border-light">
                            <div class="flex flex-col gap-1">
                                <span class="text-text-main text-sm font-bold">القناة المفضلة</span>
                                <span class="text-text-secondary text-xs">الوسيلة الأساسية للإرسال</span>
                            </div>
                            <select
                                class="bg-white text-text-main text-sm rounded-lg border border-border-medium block p-2 focus:ring-primary focus:border-primary shadow-sm w-40">
                                <option>SMS (رسائل نصية)</option>
                                <option>WhatsApp (واتساب)</option>
                                <option>Email (بريد إلكتروني)</option>
                            </select>
                        </div>
                    </div>
                    <div class="bg-gray-50 rounded-xl p-6 border border-border-light">
                        <h4 class="text-text-tertiary text-xs font-bold uppercase tracking-wider mb-4">معاينة الرسالة</h4>
                        <div class="flex items-start gap-4 max-w-md">
                            <div class="size-10 rounded-full bg-gray-200 flex-shrink-0 bg-cover bg-center border border-white shadow-sm"
                                data-alt="Avatar placeholder"
                                style='background-image: url("https://lh3.googleusercontent.com/aida-public/AB6AXuC4dT2LpVVAju1Eb9LEhk8_tG_w91exSyD5XONjfF8ctp6yiLdVSYruAfsP2TCL9-g4iFAU67miflzXYusYcSAjWNOYtzIHHjZ6rP4v4Tc5rbkQiiRgAMLbS0ZwGx7IAaEK9fpYB_-JRhtmruFaUe_FCt5o3xDLPqU3UHVh590l8sWuOpoQ9iBGbSa1l6ZPX1hSSS_hUll3s6i1oyqe1ZmautwdAHFFkwb3uXxzRyCHA4-DSHHii8T7NvvqMstjmimwAD1WFz_WTS4");'>
                            </div>
                            <div
                                class="bg-white p-4 rounded-2xl rounded-tr-none border border-border-light relative shadow-md">
                                <p class="text-text-main text-sm leading-relaxed">
                                    أهلاً <span class="bg-primary/10 text-primary font-medium px-1 rounded">سارة</span>،
                                    <br />
                                    نؤكد حجز موعدك في <span
                                        class="bg-primary/10 text-primary font-medium px-1 rounded">صالون سوان</span> يوم
                                    <span class="bg-primary/10 text-primary font-medium px-1 rounded">24 أكتوبر</span>
                                    الساعة <span class="bg-primary/10 text-primary font-medium px-1 rounded">4:00 م</span>
                                    لخدمة <span class="bg-primary/10 text-primary font-medium px-1 rounded">قص شعر</span>.
                                    <br /><br />
                                    ننتظرك بكل حب!
                                    <br />
                                    للمساعدة، يرجى الرد على هذه الرسالة.
                                </p>
                                <span class="text-[10px] text-text-tertiary absolute bottom-2 left-3">الآن</span>
                            </div>
                        </div>
                    </div>
                    <div class="flex justify-end gap-3 mt-8 pt-6 border-t border-border-light">
                        <button
                            class="px-6 py-2.5 rounded-xl border border-border-medium text-text-secondary hover:text-text-main hover:bg-gray-50 font-bold text-sm transition-colors bg-white shadow-sm">
                            إلغاء التعديلات
                        </button>
                        <button
                            class="px-8 py-2.5 rounded-xl bg-primary hover:bg-primary-hover text-white font-bold text-sm shadow-lg shadow-primary/20 transition-all flex items-center gap-2 transform active:scale-95">
                            <span class="material-symbols-outlined text-[18px]">save</span>
                            حفظ القالب
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection