@extends('layouts.app')

@section('title', 'إدارة الموظفين')


@section('content')

    <!-- Page Header -->
    <header class="p-4  md:px-12">
        <div class=" mx-auto flex flex-col gap-6">
            <div class="flex items-center gap-2 text-sm">
                <a class="text-text-secondary hover:text-primary transition-colors" href="#">الرئيسية</a>
                <span class="text-text-tertiary text-xs material-symbols-outlined rotate-180">chevron_right</span>
                <span class="text-primary font-bold">إدارة الموظفات</span>
            </div>
            <div class="flex flex-wrap justify-between items-end gap-4">
                <div class="flex flex-col gap-2">
                    <h2 class="text-text-main text-3xl md:text-4xl font-extrabold tracking-tight">إدارة الموظفات</h2>
                    <p class="text-text-secondary text-base max-w-2xl font-medium">إدارة الملفات الشخصية، الجداول
                        الزمنية، ومؤشرات الأداء
                        لموظفي الصالون.</p>
                </div>
                <div class="flex gap-3">
                    <button
                        class="px-5 py-2.5 rounded-lg bg-primary text-white font-bold text-sm hover:bg-primary/90 transition-colors shadow-md flex items-center gap-2">
                        <span class="material-symbols-outlined text-[20px]">add</span>
                        إضافة موظف جديد
                    </button>
                </div>
            </div>
        </div>
    </header>
    <!-- end page header -->

    <div class="flex-1 overflow-y-auto p-4 md:p-8 md:px-12 scroll-smooth">

        {{-- Main Grid --}}
        <div class="flex flex-col lg:flex-row gap-6 min-h-[600px]">

            {{-- Employees List --}}
            <div class="w-full lg:w-1/3 flex flex-col gap-4">

                <div class="bg-white rounded-xl p-5 border border-border-color shadow-soft">
                    <div class="relative mb-4">
                        <span class="material-symbols-outlined absolute right-3 top-1/2 -translate-y-1/2 text-text-sub">
                            search
                        </span>
                        <input type="text" placeholder="بحث باسم الموظف..."
                            class="w-full h-11 pr-10 pl-4 bg-background-light border border-border-color rounded-lg focus:border-primary focus:ring-1 focus:ring-primary outline-none text-sm" />
                    </div>

                    <div class="flex gap-2 overflow-x-auto pb-1">
                        <button class="px-4 py-1.5 bg-primary text-white text-xs font-bold rounded-full">
                            الكل
                        </button>
                        <button class="px-4 py-1.5 border rounded-full text-xs hover:border-primary">
                            تصفيف الشعر
                        </button>
                        <button class="px-4 py-1.5 border rounded-full text-xs hover:border-primary">
                            عناية بالبشرة
                        </button>
                        <button class="px-4 py-1.5 border rounded-full text-xs hover:border-primary">
                            مكياج
                        </button>
                    </div>
                </div>

                <div class="bg-white rounded-xl border border-border-color shadow-soft overflow-hidden flex flex-col">
                    <div class="p-4 border-b border-border-color font-bold">
                        قائمة الموظفين (4)
                    </div>

                    <div class="flex-1 overflow-y-auto p-3 space-y-2">

                        {{-- Employee --}}
                        <div
                            class="flex items-center gap-4 p-3 rounded-lg bg-primary-light/50 border border-primary/20 cursor-pointer">
                            <div class="relative">
                                <div class="w-14 h-14 rounded-full bg-gray-200"></div>
                                <span
                                    class="absolute bottom-0 right-0 w-3 h-3 bg-emerald-500 rounded-full border-2 border-white"></span>
                            </div>
                            <div class="flex-1">
                                <p class="font-bold">سارة محمد</p>
                                <p class="text-xs text-text-sub">خبيرة شعر أولى</p>
                            </div>
                            <span class="material-symbols-outlined text-primary">
                                chevron_left
                            </span>
                        </div>

                        {{-- Employee --}}
                        <div class="flex items-center gap-4 p-3 rounded-lg hover:bg-background-light border cursor-pointer">
                            <div class="relative">
                                <div class="w-14 h-14 rounded-full bg-gray-200"></div>
                                <span
                                    class="absolute bottom-0 right-0 w-3 h-3 bg-gray-400 rounded-full border-2 border-white"></span>
                            </div>
                            <div class="flex-1">
                                <p class="font-bold">ليلى حسن</p>
                                <p class="text-xs text-text-sub">أخصائية بشرة</p>
                            </div>
                        </div>

                    </div>
                </div>
            </div>

            {{-- Employee Details --}}
            <div class="w-full lg:w-2/3 flex flex-col gap-6">

                {{-- Profile Card --}}
                <div class="bg-white rounded-xl p-8 border border-border-color shadow-soft">
                    <div class="flex flex-col md:flex-row gap-6 items-center md:items-start">

                        <div class="w-28 h-28 rounded-full bg-gray-200"></div>

                        <div class="flex-1">
                            <div class="flex justify-between items-start gap-4">
                                <div>
                                    <h2 class="text-3xl font-bold font-display">
                                        سارة محمد
                                    </h2>
                                    <div class="flex items-center gap-3 mt-2 text-sm">
                                        <span class="px-3 py-1 bg-primary-light text-primary rounded-full font-bold">
                                            خبيرة شعر أولى
                                        </span>
                                        <span class="text-emerald-600 font-bold">
                                            نشطة الآن
                                        </span>
                                    </div>
                                </div>

                                <div class="flex gap-2">
                                    <button class="px-5 py-2 border rounded-lg font-bold">
                                        تعديل
                                    </button>
                                    <button class="px-5 py-2 bg-rose-50 text-rose-600 rounded-lg font-bold">
                                        إيقاف
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="mt-6 pt-6 border-t border-border-color flex justify-between items-center">
                        <div>
                            <p class="font-bold">استقبال الحجوزات</p>
                            <p class="text-xs text-text-sub">
                                إظهار الموظف في صفحة الحجز
                            </p>
                        </div>
                        <input type="checkbox" checked class="h-5 w-5 accent-primary">
                    </div>
                </div>

                {{-- Stats --}}
                <div class="grid grid-cols-1 sm:grid-cols-3 gap-4">

                    <div class="bg-white p-5 rounded-xl border shadow-soft flex items-center gap-4">
                        <span class="material-symbols-outlined text-primary text-3xl">
                            calendar_today
                        </span>
                        <div>
                            <p class="text-2xl font-bold">142</p>
                            <p class="text-xs text-text-sub">حجوزات الشهر</p>
                        </div>
                    </div>

                    <div class="bg-white p-5 rounded-xl border shadow-soft flex items-center gap-4">
                        <span class="material-symbols-outlined text-primary text-3xl">
                            payments
                        </span>
                        <div>
                            <p class="text-2xl font-bold">1500 ريال</p>
                            <p class="text-xs text-text-sub">الإيرادات</p>
                        </div>
                    </div>

                    <div class="bg-white p-5 rounded-xl border shadow-soft flex items-center gap-4">
                        <span class="material-symbols-outlined text-primary text-3xl">
                            block
                        </span>
                        <div>
                            <p class="text-2xl font-bold">3%</p>
                            <p class="text-xs text-text-sub">الإلغاء</p>
                        </div>
                    </div>

                </div>

            </div>

        </div>

    </div>



@endsection