<!DOCTYPE html>

<html class="light" dir="rtl" lang="ar">

<head>
    <meta charset="utf-8" />
    <meta content="width=device-width, initial-scale=1.0" name="viewport" />
    <title><?php echo $__env->yieldContent('title', 'لوحة التحكم - صالون الجمال'); ?></title>
    <link rel="icon" type="image/x-icon"
        href="https://swangroup.sa/wp-content/uploads/2023/09/5FA061E1-81B7-477E-A650-A3EBE6B30088-e1734439779218.png">

    <link
        href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:wght,FILL@100..700,0..1&amp;display=swap"
        rel="stylesheet" />

    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@200;300;400;500;700;800;900&display=swap"
        rel="stylesheet">


    <script src="https://cdn.tailwindcss.com?plugins=forms,container-queries"></script>
    <script defer src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js"></script>

    <script id="tailwind-config">
        tailwind.config = {
            darkMode: "class",
            theme: {
                extend: {
                    colors: {
                        "primary": "#8d2739",
                        "primary-soft": "#f3e8f9",
                        "background-light": "#f7f6f8",
                        "background-dark": "#1c1121",
                        "text-main": "#170e1b",
                        "text-sub": "#7f4e97",
                    },
                    fontFamily: {
                        "display": ["Tajawal", "sans-serif"],
                        "body": ["Tajawal", "sans-serif"],
                    },
                    borderRadius: { "DEFAULT": "0.5rem", "lg": "0.75rem", "xl": "1rem", "2xl": "1.5rem", "full": "9999px" },
                },
            },
        }
    </script>
    <style>
        body {
            font-family: "Tajawal", "sans-serif";
        }

        .material-symbols-outlined {
            font-variation-settings: 'FILL' 0, 'wght' 400, 'GRAD' 0, 'opsz' 24;
        }

        /* Custom scrollbar for better aesthetic */
        ::-webkit-scrollbar {
            width: 6px;
        }

        ::-webkit-scrollbar-track {
            background: transparent;
        }

        ::-webkit-scrollbar-thumb {
            background: #e0d5e5;
            border-radius: 10px;
        }

        ::-webkit-scrollbar-thumb:hover {
            background: #a219e6;
        }

        [x-cloak] {
            display: none !important;
        }
    </style>
    <?php echo $__env->make('partials.scripts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</head>

<body x-data="{ sidebarOpen: false }" :class="sidebarOpen ? 'overflow-hidden' : ''"
    class="bg-background-light dark:bg-background-dark text-text-main">

    <div class="flex h-screen w-full overflow-hidden">

        
        <?php echo $__env->make('components.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        
        <main class="flex flex-1 flex-col h-full overflow-hidden">

            
            <?php echo $__env->make('components.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

            
            <div class="flex-1 overflow-y-auto p-4 md:p-8">
                <?php echo $__env->yieldContent('content'); ?>
            </div>

        </main>
    </div>

    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>

</html><?php /**PATH D:\Work\Laravel\swan-salon-dashboard\resources\views/layouts/app.blade.php ENDPATH**/ ?>