<div x-show="twoFAOpen" x-transition.opacity class="fixed inset-0 z-50 flex items-center justify-center">

    
    <div @click="twoFAOpen = false" class="absolute inset-0 bg-black/40 backdrop-blur-sm">
    </div>

    
    <div x-transition.scale class="relative w-full max-w-md bg-white dark:bg-surface-dark
               rounded-2xl shadow-card border border-primary/10
               p-8 sm:p-10 z-10">

        
        <div class="text-center mb-8 space-y-3">
            <h2 class="text-2xl font-bold text-text-main dark:text-white">
                التحقق بخطوتين
            </h2>
            <p class="text-sm text-text-muted dark:text-gray-400 leading-relaxed">
                تم إرسال رمز تحقق إلى هاتفك المنتهي بـ
                <span class="font-bold text-primary dir-ltr" dir="ltr">**98</span>
            </p>
        </div>

        
        <div class="flex justify-center gap-3 mb-6" dir="ltr">
            <?php for($i = 0; $i < 4; $i++): ?>
                <input maxlength="1" type="number" class="w-12 h-14 text-center text-2xl font-bold
                                       bg-white dark:bg-gray-800/50
                                       border border-gray-200 dark:border-gray-700
                                       rounded-lg focus:outline-none focus:ring-2
                                       focus:ring-primary/20 focus:border-primary
                                       text-primary transition-all">
            <?php endfor; ?>
        </div>

        
        <div class="space-y-4">
            <button class="w-full py-3.5 rounded-lg bg-primary text-white font-bold
                       hover:bg-primary-dark transition-all">
                تحقق والدخول
            </button>

            <button @click="twoFAOpen = false" class="w-full py-2.5 rounded-lg text-sm font-medium
                       text-text-muted hover:text-primary transition">
                تراجع
            </button>
        </div>
    </div>
</div><?php /**PATH D:\Work\Laravel\swan-salon-dashboard\resources\views/components/auth/two-factor-popup.blade.php ENDPATH**/ ?>