

<?php $__env->startSection('title', 'إدارة الكوبونات والخصومات'); ?>

<?php $__env->startSection('content'); ?>

    <!-- Page Header -->
    <header class="p-4  md:px-12">
        <div class=" mx-auto flex flex-col gap-6">
            <div class="flex items-center gap-2 text-sm">
                <a class="text-text-secondary hover:text-primary transition-colors" href="#">الرئيسية</a>
                <span class="text-text-tertiary text-xs material-symbols-outlined rotate-180">chevron_right</span>
                <span class="text-primary font-bold">إدارة الكوبونات</span>
            </div>
            <div class="flex flex-wrap justify-between items-end gap-4">
                <div class="flex flex-col gap-2">
                    <h2 class="text-text-main text-3xl md:text-4xl font-extrabold tracking-tight">إدارة الكوبونات</h2>
                    <p class="text-text-secondary text-base max-w-2xl font-medium">إدارة أكواد الخصم والعروض الترويجية
                        لعملائك المميزين.</p>
                </div>
                <div class="flex gap-3">
                    <button
                        class="hidden md:flex items-center gap-2 px-5 py-2.5 rounded-lg border border-gray-200 bg-white dark:bg-white/5 dark:border-gray-700 text-gray-700 dark:text-white text-sm font-medium hover:bg-gray-50 hover:border-primary/30 transition-all shadow-sm">
                        <span class="material-symbols-outlined text-[20px]">file_download</span>
                        <span>تصدير التقرير</span>
                    </button>
                    <button
                        class="px-5 py-2.5 rounded-lg bg-primary text-white font-bold text-sm hover:bg-primary/90 transition-colors shadow-md flex items-center gap-2">
                        <span class="material-symbols-outlined text-[20px]">add</span>
                        إضافة كوبون جديد
                    </button>
                </div>
            </div>
        </div>
    </header>
    <!-- end page header -->

    <div class="flex-1 overflow-y-auto p-4 md:p-8 md:px-12 scroll-smooth">

        <div class="grid grid-cols-1 md:grid-cols-3 gap-5">
            <div
                class="bg-white dark:bg-[#221010] rounded-xl p-6 border border-gray-100 dark:border-gray-800 shadow-soft flex flex-col gap-2 relative overflow-hidden group hover:shadow-md transition-shadow">
                <div
                    class="absolute -left-6 -top-6 size-32 bg-primary/5 rounded-full blur-xl group-hover:bg-primary/10 transition-colors duration-500">
                </div>
                <div class="flex items-center justify-between relative z-10">
                    <p class="text-gray-500 text-sm font-medium">الكوبونات النشطة</p>
                    <span
                        class="material-symbols-outlined text-primary bg-primary-light dark:bg-primary/20 p-2 rounded-lg text-[22px]">local_activity</span>
                </div>
                <div class="flex items-baseline gap-2 mt-2 relative z-10">
                    <h3 class="text-3xl font-bold text-gray-900 dark:text-white">12</h3>
                </div>
                <p
                    class="text-emerald-600 text-xs font-medium flex items-center gap-1 mt-1 relative z-10 bg-emerald-50 w-fit px-2 py-0.5 rounded-full border border-emerald-100">
                    <span class="material-symbols-outlined text-[14px]">trending_up</span>
                    +2 كوبون جديد هذا الشهر
                </p>
            </div>
            <div
                class="bg-white dark:bg-[#221010] rounded-xl p-6 border border-gray-100 dark:border-gray-800 shadow-soft flex flex-col gap-2 relative overflow-hidden group hover:shadow-md transition-shadow">
                <div
                    class="absolute -left-6 -top-6 size-32 bg-accent-gold/5 rounded-full blur-xl group-hover:bg-accent-gold/10 transition-colors duration-500">
                </div>
                <div class="flex items-center justify-between relative z-10">
                    <p class="text-gray-500 text-sm font-medium">إجمالي الاستخدامات</p>
                    <span
                        class="material-symbols-outlined text-accent-gold bg-yellow-50 dark:bg-yellow-900/20 p-2 rounded-lg text-[22px]">confirmation_number</span>
                </div>
                <div class="flex items-baseline gap-2 mt-2 relative z-10">
                    <h3 class="text-3xl font-bold text-gray-900 dark:text-white">450</h3>
                </div>
                <p
                    class="text-emerald-600 text-xs font-medium flex items-center gap-1 mt-1 relative z-10 bg-emerald-50 w-fit px-2 py-0.5 rounded-full border border-emerald-100">
                    <span class="material-symbols-outlined text-[14px]">trending_up</span>
                    +12% مقارنة بالشهر الماضي
                </p>
            </div>
            <div
                class="bg-white dark:bg-[#221010] rounded-xl p-6 border border-gray-100 dark:border-gray-800 shadow-soft flex flex-col gap-2 relative overflow-hidden group hover:shadow-md transition-shadow">
                <div
                    class="absolute -left-6 -top-6 size-32 bg-primary/5 rounded-full blur-xl group-hover:bg-primary/10 transition-colors duration-500">
                </div>
                <div class="flex items-center justify-between relative z-10">
                    <p class="text-gray-500 text-sm font-medium">العائد من الخصومات</p>
                    <span
                        class="material-symbols-outlined text-primary bg-primary-light dark:bg-primary/20 p-2 rounded-lg text-[22px]">payments</span>
                </div>
                <div class="flex items-baseline gap-2 mt-2 relative z-10">
                    <h3 class="text-3xl font-bold text-gray-900 dark:text-white">12,500 <span
                            class="text-sm font-normal text-gray-400">ر.س</span></h3>
                </div>
                <p class="text-gray-400 text-xs font-medium mt-1 relative z-10">إجمالي المبيعات باستخدام الكوبون</p>
            </div>
        </div>
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8 items-start">
            <div class="lg:col-span-2 flex flex-col gap-5">
                <div
                    class="flex flex-wrap items-center gap-3 bg-white dark:bg-[#221010] p-2 rounded-xl border border-gray-100 dark:border-gray-800 shadow-sm">
                    <div class="relative flex-1 min-w-[200px]">
                        <span class="absolute inset-y-0 right-3 flex items-center text-gray-400">
                            <span class="material-symbols-outlined text-[20px]">search</span>
                        </span>
                        <input
                            class="w-full pl-4 pr-10 py-2.5 bg-gray-50 dark:bg-white/5 border-0 rounded-lg text-sm focus:outline-none focus:ring-2 focus:ring-primary/20 transition-all placeholder-gray-400"
                            placeholder="بحث عن كوبون..." type="text" />
                    </div>
                    <div class="border-r border-gray-200 h-8 mx-1"></div>
                    <select
                        class="bg-transparent border-0 text-gray-700 dark:text-white text-sm rounded-lg focus:ring-0 cursor-pointer py-2.5 px-4 font-medium hover:bg-gray-50 dark:hover:bg-white/5 transition-colors">
                        <option>جميع الحالات</option>
                        <option>نشط</option>
                        <option>منتهي</option>
                        <option>مجدول</option>
                    </select>
                </div>
                <div
                    class="bg-white dark:bg-[#221010] border border-gray-100 dark:border-gray-800 rounded-xl shadow-soft overflow-hidden">
                    <div class="overflow-x-auto">
                        <table class="w-full text-sm text-right text-gray-500 dark:text-gray-400">
                            <thead
                                class="text-xs text-gray-500 uppercase bg-gray-50/50 dark:bg-white/5 border-b border-gray-100 dark:border-gray-800/50">
                                <tr>
                                    <th class="px-6 py-4 font-bold tracking-wider" scope="col">كود الكوبون</th>
                                    <th class="px-6 py-4 font-bold tracking-wider" scope="col">نوع الخصم</th>
                                    <th class="px-6 py-4 font-bold tracking-wider" scope="col">الاستخدام</th>
                                    <th class="px-6 py-4 font-bold tracking-wider" scope="col">الحالة</th>
                                    <th class="px-6 py-4 font-bold tracking-wider" scope="col">انتهاء الصلاحية</th>
                                    <th class="px-6 py-4 font-bold text-center tracking-wider" scope="col">إجراءات</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-50 dark:divide-gray-800/50">
                                <tr
                                    class="bg-white dark:bg-[#221010] hover:bg-gray-50/80 dark:hover:bg-white/5 transition-colors group">
                                    <td class="px-6 py-4 font-medium text-gray-900 dark:text-white">
                                        <div class="flex items-center gap-2">
                                            <span
                                                class="font-mono bg-primary/5 text-primary border border-primary/10 px-2.5 py-1 rounded text-xs font-bold tracking-wider">SUMMER20</span>
                                            <span class="material-symbols-outlined text-[16px] text-accent-gold"
                                                title="تطبيق تلقائي">bolt</span>
                                        </div>
                                        <p class="text-xs text-gray-400 mt-1.5 font-light">خصم الصيف الخاص</p>
                                    </td>
                                    <td class="px-6 py-4">
                                        <span class="text-gray-900 dark:text-white font-bold">20%</span>
                                        <p class="text-[11px] text-gray-400 mt-0.5">حد أقصى 50 ر.س</p>
                                    </td>
                                    <td class="px-6 py-4">
                                        <div class="flex flex-col gap-1.5 w-24">
                                            <div class="flex justify-between text-[10px] text-gray-400">
                                                <span>45</span>
                                                <span>100</span>
                                            </div>
                                            <div class="h-1.5 bg-gray-100 rounded-full overflow-hidden w-full">
                                                <div class="h-full bg-primary w-[45%] rounded-full"></div>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="px-6 py-4">
                                        <span
                                            class="bg-emerald-50 text-emerald-700 text-xs font-medium px-2.5 py-1 rounded-full dark:bg-emerald-900/30 dark:text-emerald-400 border border-emerald-100 dark:border-emerald-800/50">نشط</span>
                                    </td>
                                    <td class="px-6 py-4 font-mono text-xs text-gray-500">
                                        2023-12-31
                                    </td>
                                    <td class="px-6 py-4 text-center">
                                        <div
                                            class="flex justify-center gap-1 opacity-60 group-hover:opacity-100 transition-opacity">
                                            <button
                                                class="size-8 flex items-center justify-center rounded-full hover:bg-primary/5 hover:text-primary text-gray-400 transition-colors">
                                                <span class="material-symbols-outlined text-[18px]">edit</span>
                                            </button>
                                            <button
                                                class="size-8 flex items-center justify-center rounded-full hover:bg-red-50 hover:text-red-600 text-gray-400 transition-colors">
                                                <span class="material-symbols-outlined text-[18px]">delete</span>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                                <tr
                                    class="bg-white dark:bg-[#221010] hover:bg-gray-50/80 dark:hover:bg-white/5 transition-colors group">
                                    <td class="px-6 py-4 font-medium text-gray-900 dark:text-white">
                                        <div class="flex items-center gap-2">
                                            <span
                                                class="font-mono bg-gray-100 dark:bg-white/10 px-2.5 py-1 rounded text-gray-600 dark:text-gray-300 text-xs font-bold tracking-wider">WELCOME10</span>
                                        </div>
                                        <p class="text-xs text-gray-400 mt-1.5 font-light">للعملاء الجدد</p>
                                    </td>
                                    <td class="px-6 py-4">
                                        <span class="text-gray-900 dark:text-white font-bold">10 ر.س</span>
                                        <p class="text-[11px] text-gray-400 mt-0.5">خصم ثابت</p>
                                    </td>
                                    <td class="px-6 py-4">
                                        <div class="flex flex-col gap-1.5 w-24">
                                            <div class="flex justify-between text-[10px] text-gray-400">
                                                <span>12</span>
                                                <span>∞</span>
                                            </div>
                                            <div class="h-1.5 bg-gray-100 rounded-full overflow-hidden w-full">
                                                <div class="h-full bg-emerald-500 w-[12%] rounded-full"></div>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="px-6 py-4">
                                        <span
                                            class="bg-emerald-50 text-emerald-700 text-xs font-medium px-2.5 py-1 rounded-full dark:bg-emerald-900/30 dark:text-emerald-400 border border-emerald-100 dark:border-emerald-800/50">نشط</span>
                                    </td>
                                    <td class="px-6 py-4 text-xs text-gray-500">
                                        دائم
                                    </td>
                                    <td class="px-6 py-4 text-center">
                                        <div
                                            class="flex justify-center gap-1 opacity-60 group-hover:opacity-100 transition-opacity">
                                            <button
                                                class="size-8 flex items-center justify-center rounded-full hover:bg-primary/5 hover:text-primary text-gray-400 transition-colors">
                                                <span class="material-symbols-outlined text-[18px]">edit</span>
                                            </button>
                                            <button
                                                class="size-8 flex items-center justify-center rounded-full hover:bg-red-50 hover:text-red-600 text-gray-400 transition-colors">
                                                <span class="material-symbols-outlined text-[18px]">delete</span>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                                <tr class="bg-white dark:bg-[#221010] opacity-60 hover:opacity-100 transition-all group">
                                    <td class="px-6 py-4 font-medium text-gray-900 dark:text-white">
                                        <div class="flex items-center gap-2">
                                            <span
                                                class="font-mono bg-gray-100 dark:bg-white/10 px-2.5 py-1 rounded text-gray-500 border border-transparent text-xs font-bold tracking-wider">EID2023</span>
                                        </div>
                                        <p class="text-xs text-gray-400 mt-1.5 font-light">عرض العيد</p>
                                    </td>
                                    <td class="px-6 py-4">
                                        <span class="text-gray-900 dark:text-white font-bold">25%</span>
                                    </td>
                                    <td class="px-6 py-4">
                                        <div class="flex flex-col gap-1.5 w-24">
                                            <div class="flex justify-between text-[10px] text-gray-400">
                                                <span>200</span>
                                                <span>200</span>
                                            </div>
                                            <div class="h-1.5 bg-gray-100 rounded-full overflow-hidden w-full">
                                                <div class="h-full bg-gray-400 w-[100%] rounded-full"></div>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="px-6 py-4">
                                        <span
                                            class="bg-gray-100 text-gray-600 text-xs font-medium px-2.5 py-1 rounded-full dark:bg-gray-800 dark:text-gray-400 border border-gray-200 dark:border-gray-700">منتهي</span>
                                    </td>
                                    <td class="px-6 py-4 font-mono text-xs text-gray-500">
                                        2023-04-25
                                    </td>
                                    <td class="px-6 py-4 text-center">
                                        <div
                                            class="flex justify-center gap-1 opacity-60 group-hover:opacity-100 transition-opacity">
                                            <button
                                                class="size-8 flex items-center justify-center rounded-full hover:bg-gray-100 hover:text-gray-600 text-gray-400 transition-colors">
                                                <span class="material-symbols-outlined text-[18px]">visibility</span>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="px-6 py-4 border-t border-gray-100 dark:border-gray-800 flex items-center justify-between">
                        <span class="text-xs text-gray-500">عرض 1-3 من 12</span>
                        <div class="flex gap-1.5">
                            <button
                                class="size-8 flex items-center justify-center rounded-lg border border-gray-200 hover:bg-gray-50 text-gray-500 disabled:opacity-50 transition-colors">
                                <span class="material-symbols-outlined text-[16px]">chevron_right</span>
                            </button>
                            <button
                                class="size-8 flex items-center justify-center rounded-lg bg-primary text-white font-bold text-sm shadow-sm">1</button>
                            <button
                                class="size-8 flex items-center justify-center rounded-lg border border-gray-200 hover:bg-gray-50 text-gray-500 transition-colors">2</button>
                            <button
                                class="size-8 flex items-center justify-center rounded-lg border border-gray-200 hover:bg-gray-50 text-gray-500 transition-colors">
                                <span class="material-symbols-outlined text-[16px]">chevron_left</span>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="lg:col-span-1">
                <div
                    class="bg-white dark:bg-[#221010] border border-gray-100 dark:border-gray-800 rounded-xl shadow-soft sticky top-28 overflow-hidden">
                    <div
                        class="p-5 border-b border-gray-100 dark:border-gray-800 flex justify-between items-center bg-gray-50/30 dark:bg-white/5">
                        <h3 class="font-bold text-gray-900 dark:text-white flex items-center gap-2.5 text-lg">
                            <div class="size-8 rounded-full bg-primary/10 flex items-center justify-center">
                                <span class="material-symbols-outlined text-primary text-[20px]">add</span>
                            </div>
                            إنشاء كوبون جديد
                        </h3>
                    </div>
                    <div class="p-6 flex flex-col gap-6">
                        <div class="flex flex-col gap-2">
                            <label class="text-sm font-semibold text-gray-700 dark:text-gray-300">رمز الكوبون</label>
                            <div class="flex gap-2 relative">
                                <input
                                    class="flex-1 bg-gray-50 dark:bg-white/5 border border-gray-200 dark:border-gray-700 rounded-lg px-4 py-3 text-sm uppercase font-mono tracking-wider focus:ring-2 focus:ring-primary/10 focus:border-primary transition-all text-center placeholder-gray-400"
                                    placeholder="مثال: SAVE20" type="text" />
                                <button
                                    class="absolute left-1.5 top-1.5 bottom-1.5 px-3 text-primary bg-white shadow-sm border border-gray-100 hover:bg-gray-50 rounded-md text-sm font-medium transition-colors"
                                    title="توليد كود عشوائي">
                                    <span class="material-symbols-outlined text-[20px]">autorenew</span>
                                </button>
                            </div>
                        </div>
                        <div class="flex flex-col gap-2">
                            <label class="text-sm font-semibold text-gray-700 dark:text-gray-300">وصف الكوبون</label>
                            <input
                                class="w-full bg-gray-50 dark:bg-white/5 border border-gray-200 dark:border-gray-700 rounded-lg px-4 py-3 text-sm focus:ring-2 focus:ring-primary/10 focus:border-primary transition-all placeholder-gray-400"
                                placeholder="وصف قصير للكوبون (اختياري)" type="text" />
                        </div>
                        <div>
                            <label class="text-sm font-semibold text-gray-700 dark:text-gray-300 mb-2.5 block">نوع
                                الخصم</label>
                            <div class="grid grid-cols-2 bg-gray-100 dark:bg-black/30 p-1.5 rounded-lg gap-1">
                                <button
                                    class="py-2 text-sm font-bold rounded-md shadow-sm bg-white dark:bg-[#221010] text-primary transition-all flex items-center justify-center gap-2 border border-gray-200/50">
                                    <span class="material-symbols-outlined text-[18px]">percent</span>
                                    نسبة مئوية
                                </button>
                                <button
                                    class="py-2 text-sm font-medium rounded-md text-gray-500 hover:text-gray-700 dark:text-gray-400 hover:bg-gray-200/50 transition-all flex items-center justify-center gap-2">
                                    <span class="material-symbols-outlined text-[18px]">attach_money</span>
                                    مبلغ ثابت
                                </button>
                            </div>
                        </div>
                        <div class="grid grid-cols-2 gap-4">
                            <div class="flex flex-col gap-2">
                                <label class="text-xs font-semibold text-gray-500 uppercase tracking-wide">قيمة
                                    الخصم</label>
                                <div class="relative">
                                    <input
                                        class="w-full bg-white dark:bg-white/5 border border-gray-200 dark:border-gray-700 rounded-lg px-4 py-2.5 text-sm focus:ring-2 focus:ring-primary/10 focus:border-primary pl-8 font-bold text-gray-800 dark:text-gray-200"
                                        placeholder="0" type="number" />
                                    <span class="absolute left-3 top-2.5 text-gray-400 text-sm font-bold">%</span>
                                </div>
                            </div>
                            <div class="flex flex-col gap-2">
                                <label class="text-xs font-semibold text-gray-500 uppercase tracking-wide">الحد
                                    الأقصى</label>
                                <div class="relative">
                                    <input
                                        class="w-full bg-white dark:bg-white/5 border border-gray-200 dark:border-gray-700 rounded-lg px-4 py-2.5 text-sm focus:ring-2 focus:ring-primary/10 focus:border-primary pl-8 font-bold text-gray-800 dark:text-gray-200"
                                        placeholder="∞" type="number" />
                                    <span class="absolute left-3 top-3 text-gray-400 text-[10px]">ر.س</span>
                                </div>
                            </div>
                        </div>
                        <hr class="border-dashed border-gray-200 dark:border-gray-700" />
                        <div class="flex flex-col gap-2">
                            <label class="text-sm font-semibold text-gray-700 dark:text-gray-300">يطبق على</label>
                            <div class="relative">
                                <select
                                    class="w-full appearance-none bg-gray-50 dark:bg-white/5 border border-gray-200 dark:border-gray-700 rounded-lg px-4 py-3 text-sm focus:ring-2 focus:ring-primary/10 focus:border-primary cursor-pointer">
                                    <option>جميع الخدمات</option>
                                    <option>خدمات محددة</option>
                                    <option>فئات محددة</option>
                                </select>
                                <span class="absolute left-3 top-3.5 pointer-events-none text-gray-500">
                                    <span class="material-symbols-outlined text-[20px]">expand_more</span>
                                </span>
                            </div>
                        </div>
                        <div class="flex flex-col gap-2">
                            <label class="text-sm font-semibold text-gray-700 dark:text-gray-300">تاريخ الانتهاء</label>
                            <div class="relative">
                                <input
                                    class="w-full bg-gray-50 dark:bg-white/5 border border-gray-200 dark:border-gray-700 rounded-lg px-4 py-3 text-sm text-gray-600 focus:ring-2 focus:ring-primary/10 focus:border-primary"
                                    type="date" />
                            </div>
                        </div>
                        <div
                            class="flex items-center justify-between p-3.5 bg-yellow-50/50 dark:bg-yellow-900/10 rounded-lg border border-yellow-100 dark:border-yellow-900/20">
                            <div class="flex flex-col gap-0.5">
                                <span class="text-sm font-bold text-gray-800 dark:text-white flex items-center gap-1.5">
                                    <span class="material-symbols-outlined text-accent-gold text-[18px]">bolt</span>
                                    تطبيق تلقائي
                                </span>
                                <span class="text-[11px] text-gray-500 pr-6">تطبيق الخصم مباشرة دون كود</span>
                            </div>
                            <label class="relative inline-flex items-center cursor-pointer">
                                <input class="sr-only peer" type="checkbox" value="" />
                                <div
                                    class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full rtl:peer-checked:after:-translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:start-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-primary">
                                </div>
                            </label>
                        </div>
                        <div class="flex items-center gap-2.5">
                            <div class="relative flex items-center">
                                <input
                                    class="peer h-5 w-5 cursor-pointer appearance-none rounded border border-gray-300 checked:bg-primary checked:border-primary focus:ring-2 focus:ring-primary/20 transition-all"
                                    id="limit_usage" type="checkbox" />
                                <span
                                    class="absolute text-white opacity-0 peer-checked:opacity-100 top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 pointer-events-none">
                                    <svg class="h-3.5 w-3.5" fill="currentColor" viewBox="0 0 20 20"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path clip-rule="evenodd"
                                            d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z"
                                            fill-rule="evenodd"></path>
                                    </svg>
                                </span>
                            </div>
                            <label class="text-sm text-gray-600 dark:text-gray-300 cursor-pointer select-none"
                                for="limit_usage">تحديد عدد مرات الاستخدام</label>
                        </div>
                        <button
                            class="mt-2 w-full bg-primary hover:bg-primary-dark text-white font-bold py-3.5 px-4 rounded-lg shadow-lg shadow-primary/20 hover:shadow-xl hover:shadow-primary/30 transition-all flex justify-center items-center gap-2 group transform active:scale-[0.98]">
                            <span class="material-symbols-outlined text-[20px] group-hover:animate-pulse">save</span>
                            حفظ الكوبون الجديد
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Work\Laravel\swan-salon-dashboard\resources\views/pages/marketing/coupons/index.blade.php ENDPATH**/ ?>