<div
    class="absolute top-full bg-white  left-0 mt-3 w-[400px] dark:bg-[#1e1424] rounded-xl shadow-dropdown border border-[#ebdada]/50 overflow-hidden transform origin-top-left z-50 animate-in fade-in zoom-in-95 duration-200">
    <!-- Panel Header -->
    <div class="flex items-center justify-between px-5 py-4 border-b border-[#f3e6e6]">
        <div class="flex items-center gap-2">
            <h3 class="text-lg font-bold text-[#191010] dark:text-white">الإشعارات</h3>
            <span class="bg-primary/10 text-primary text-xs font-bold px-2 py-0.5 rounded-full">3 جديد</span>
        </div>
        <button class="text-xs font-medium text-text-secondary hover:text-primary transition-colors hover:underline">
            مسح الكل
        </button>
    </div>
    <!-- Notification List (Scrollable) -->
    <div class="flex flex-col max-h-[400px] overflow-y-auto custom-scrollbar">
        <!-- Item 1: Unread (Booking) -->
        <div
            class="group relative flex items-start gap-4 p-4 hover:bg-primary-soft/50 transition-colors cursor-pointer border-b border-[#f8f1f1] last:border-0">
            <!-- Unread Indicator -->
            <span class="absolute top-6 right-2 w-2 h-2 bg-primary rounded-full"></span>
            <!-- Icon -->
            <div
                class="flex-shrink-0 w-10 h-10 rounded-full bg-[#fceceb] text-primary flex items-center justify-center">
                <span class="material-symbols-outlined text-[20px]">calendar_month</span>
            </div>
            <!-- Content -->
            <div class="flex-1 min-w-0 mr-2"> <!-- mr-2 for RTL spacing from unread dot visually -->
                <div class="flex justify-between items-start mb-0.5">
                    <p class="text-sm font-bold text-[#191010] dark:text-white truncate">حجز جديد مؤكد</p>
                    <span class="text-[11px] text-[#a07e7e] whitespace-nowrap">منذ 10 دقائق</span>
                </div>
                <p class="text-sm text-[#5c4040] leading-snug line-clamp-2">العميلة <span
                        class="font-medium text-primary">ريم عبدالله</span> حجزت موعد لخدمة "باكج العروس الملكي".</p>
            </div>
        </div>
        <!-- Item 2: Unread (Inventory Warning) -->
        <div
            class="group relative flex items-start gap-4 p-4 hover:bg-primary-soft/50 transition-colors cursor-pointer border-b border-[#f8f1f1] last:border-0">
            <!-- Unread Indicator -->
            <span class="absolute top-6 right-2 w-2 h-2 bg-primary rounded-full"></span>
            <!-- Icon -->
            <div
                class="flex-shrink-0 w-10 h-10 rounded-full bg-[#fff4e5] text-[#b45309] flex items-center justify-center">
                <span class="material-symbols-outlined text-[20px]">inventory_2</span>
            </div>
            <!-- Content -->
            <div class="flex-1 min-w-0 mr-2">
                <div class="flex justify-between items-start mb-0.5">
                    <p class="text-sm font-bold text-[#191010] dark:text-white truncate">تنبيه المخزون</p>
                    <span class="text-[11px] text-[#a07e7e] whitespace-nowrap">منذ 45 دقيقة</span>
                </div>
                <p class="text-sm text-[#5c4040] leading-snug line-clamp-2">كمية <span class="font-medium">زيت
                        الأرجان</span> منخفضة جداً (تبقى 3 عبوات).</p>
            </div>
        </div>
        <!-- Item 3: Unread (Staff) -->
        <div
            class="group relative flex items-start gap-4 p-4 hover:bg-primary-soft/50 transition-colors cursor-pointer border-b border-[#f8f1f1] last:border-0">
            <!-- Unread Indicator -->
            <span class="absolute top-6 right-2 w-2 h-2 bg-primary rounded-full"></span>
            <!-- Icon -->
            <div
                class="flex-shrink-0 w-10 h-10 rounded-full bg-[#eef2ff] text-[#4338ca] flex items-center justify-center">
                <span class="material-symbols-outlined text-[20px]">person_off</span>
            </div>
            <!-- Content -->
            <div class="flex-1 min-w-0 mr-2">
                <div class="flex justify-between items-start mb-0.5">
                    <p class="text-sm font-bold text-[#191010] dark:text-white truncate">طلب إجازة</p>
                    <span class="text-[11px] text-[#a07e7e] whitespace-nowrap">منذ ساعتين</span>
                </div>
                <p class="text-sm text-[#5c4040] leading-snug line-clamp-2">الموظفة <span
                        class="font-medium">ليلى</span> تطلب إجازة طارئة ليوم غد.</p>
            </div>
        </div>
        <!-- Item 4: Read (System) -->
        <div
            class="group relative flex items-start gap-4 p-4 hover:bg-gray-50 dark:hover:bg-[#2f2222] transition-colors cursor-pointer border-b border-[#f8f1f1] last:border-0 opacity-80 hover:opacity-100">
            <!-- No Unread Indicator -->
            <!-- Icon -->
            <div
                class="flex-shrink-0 w-10 h-10 rounded-full bg-[#f1f5f9] text-[#64748b] flex items-center justify-center">
                <span class="material-symbols-outlined text-[20px]">settings_backup_restore</span>
            </div>
            <!-- Content -->
            <div class="flex-1 min-w-0 mr-2">
                <div class="flex justify-between items-start mb-0.5">
                    <p class="text-sm font-semibold text-[#191010] dark:text-white truncate">نسخ احتياطي للنظام</p>
                    <span class="text-[11px] text-[#a07e7e] whitespace-nowrap">أمس</span>
                </div>
                <p class="text-sm text-[#5c4040] leading-snug line-clamp-2">تم إجراء النسخ الاحتياطي الأسبوعي بنجاح.</p>
            </div>
        </div>
        <!-- Item 5: Read (Review) -->
        <div
            class="group relative flex items-start gap-4 p-4 hover:bg-gray-50 dark:hover:bg-[#2f2222] transition-colors cursor-pointer opacity-80 hover:opacity-100">
            <!-- Icon -->
            <div
                class="flex-shrink-0 w-10 h-10 rounded-full bg-[#ecfdf5] text-[#059669] flex items-center justify-center">
                <span class="material-symbols-outlined text-[20px]">star</span>
            </div>
            <!-- Content -->
            <div class="flex-1 min-w-0 mr-2">
                <div class="flex justify-between items-start mb-0.5">
                    <p class="text-sm font-semibold text-[#191010] dark:text-white truncate">تقييم جديد 5 نجوم</p>
                    <span class="text-[11px] text-[#a07e7e] whitespace-nowrap">أمس</span>
                </div>
                <p class="text-sm text-[#5c4040] leading-snug line-clamp-2">حصلت على تقييم ممتاز من العميلة منى.</p>
            </div>
        </div>
    </div>
    <!-- Panel Footer -->
    <div class="p-3 bg-[#fdfbfb] dark:bg-[#251818] border-t border-[#f3e6e6]">
        <a href="<?php echo e(route('notifications')); ?>"
            class="w-full flex items-center justify-center gap-2 py-2.5 rounded-lg text-primary bg-transparent hover:bg-primary/5 transition-all text-sm font-bold">
            <span>عرض كل الإشعارات</span>
            <span class="material-symbols-outlined text-[16px] rtl:rotate-180">arrow_forward</span>
        </a>
    </div>
</div><?php /**PATH D:\Work\Laravel\swan-salon-dashboard\resources\views/components/notification-popup.blade.php ENDPATH**/ ?>