<header class="flex items-center justify-between
           px-4 md:px-8 py-4 md:py-5
           bg-white/80 dark:bg-[#1e1424]/90
           backdrop-blur-md
           border-b border-[#efe7f3] dark:border-[#2d2235]
           z-20">

    
    <div class="flex items-center gap-3">

        
        <button @click="sidebarOpen = true" class="lg:hidden flex items-center justify-center size-10
                   rounded-xl hover:bg-gray-100 dark:hover:bg-gray-700
                   transition">
            <span class="material-symbols-outlined">menu</span>
        </button>

        
        <div class="hidden md:flex items-center
                   bg-white dark:bg-gray-800
                   border border-gray-200 dark:border-gray-700
                   rounded-xl h-11 w-80 px-4
                   shadow-sm focus-within:ring-2 ring-primary/20
                   transition-all">
            <span class="material-symbols-outlined text-gray-400">search</span>
            <input class="w-full bg-transparent border-none text-sm
                       text-text-main dark:text-white
                       placeholder:text-gray-400
                       focus:ring-0 mr-3" placeholder="بحث عن حجز، عميل، أو موظف..." />
        </div>

        
        <button @click="searchOpen = true" class="md:hidden flex items-center justify-center size-10
                   rounded-xl hover:bg-gray-100 dark:hover:bg-gray-700
                   transition">
            <span class="material-symbols-outlined">search</span>
        </button>
    </div>

    
    <div class="flex items-center gap-4">

        
        <div x-data="{ notificationsOpen: false }" class="relative">

            
            <button @click="notificationsOpen = !notificationsOpen" class="relative flex items-center justify-center size-10
               rounded-full hover:bg-gray-100 dark:hover:bg-gray-700
               transition text-gray-600 dark:text-gray-300 focus:outline-none">

                <span class="material-symbols-outlined">notifications</span>

                
                <span class="absolute top-2 left-2 size-2.5 bg-red-500
                   rounded-full border-2 border-white
                   dark:border-[#1e1424]"></span>
            </button>

            
            <div x-show="notificationsOpen" x-transition:enter="transition ease-out duration-200"
                x-transition:enter-start="opacity-0 scale-95" x-transition:enter-end="opacity-100 scale-100"
                x-transition:leave="transition ease-in duration-150" x-transition:leave-start="opacity-100 scale-100"
                x-transition:leave-end="opacity-0 scale-95" @click.outside="notificationsOpen = false" x-cloak>
                <?php if (isset($component)) { $__componentOriginal30cfb8e27d377172ee355e8a9efdd409 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal30cfb8e27d377172ee355e8a9efdd409 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.notification-popup','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('notification-popup'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal30cfb8e27d377172ee355e8a9efdd409)): ?>
<?php $attributes = $__attributesOriginal30cfb8e27d377172ee355e8a9efdd409; ?>
<?php unset($__attributesOriginal30cfb8e27d377172ee355e8a9efdd409); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal30cfb8e27d377172ee355e8a9efdd409)): ?>
<?php $component = $__componentOriginal30cfb8e27d377172ee355e8a9efdd409; ?>
<?php unset($__componentOriginal30cfb8e27d377172ee355e8a9efdd409); ?>
<?php endif; ?>
            </div>

        </div>


        
        <!-- <button class="hidden sm:flex items-center justify-center size-10
                   rounded-full hover:bg-gray-100 dark:hover:bg-gray-700
                   transition text-gray-600 dark:text-gray-300">
            <span class="material-symbols-outlined">chat_bubble</span>
        </button> -->

        
        <div class="hidden sm:block h-8 w-px bg-gray-200 dark:bg-gray-700"></div>

        
        <div x-data="{ userMenu: false }" class="relative">

            <button @click="userMenu = !userMenu" class="flex items-center gap-3 focus:outline-none">
                <div class="text-left hidden sm:block">
                    <p class="text-sm font-bold">
                        <?php echo e(auth()->user()->name ?? 'أمل القحطاني'); ?>

                    </p>
                    <p class="text-xs text-text-sub">
                        <?php echo e(auth()->user()->role ?? 'مدير الصالون'); ?>

                    </p>
                </div>

                <div class="bg-center bg-no-repeat bg-cover
                           rounded-full size-10
                           shadow-sm border border-gray-100"
                    style='background-image: url("https://lh3.googleusercontent.com/aida-public/AB6AXuDVWUe2go0ZNJa7mhcxTQIpCUIYnbl4SGXOuLKNJ_9Z0NyvM3doAjIvlfHzC9rATeInJdrpJI_VP5mJO1NGcCRUq3ccapAjdntrmaNeKsg6xifK9Rg6WhjtaRag_wluhV6bzkj9bSFtJ9xbubJofwjcgrJdCgvTZXfRiIE3wy2ikgu_dJ_fZfD5oUPCa-QuapMrlVBJzQdOatUoYF09l7Y8-jqd4EHvpjwZOgNuPVqf__5MyXoKmzdNl8KEJPghGPZ9pwudNAZVyWo");'>
                </div>
            </button>

            
            <div x-show="userMenu" x-transition @click.outside="userMenu = false" class="absolute left-0 mt-3 w-48
                       bg-white dark:bg-gray-800
                       border border-gray-100 dark:border-gray-700
                       rounded-xl shadow-lg overflow-hidden z-30">
                <a href="" class="block px-4 py-3 text-sm hover:bg-gray-50 dark:hover:bg-gray-700">
                    الملف الشخصي
                </a>

                <a href="" class="block px-4 py-3 text-sm hover:bg-gray-50 dark:hover:bg-gray-700">
                    الإعدادات
                </a>


                <button class="w-full text-right px-4 py-3 text-sm
                               text-red-600 hover:bg-red-50 dark:hover:bg-red-900/20">
                    تسجيل الخروج
                </button>

            </div>
        </div>

    </div>
</header><?php /**PATH D:\Work\Laravel\swan-salon-dashboard\resources\views/components/header.blade.php ENDPATH**/ ?>