

<?php $__env->startSection('title', 'تسجيل الدخول'); ?>

<?php $__env->startSection('content'); ?>

    <body
        class="bg-background-light dark:bg-background-dark min-h-screen flex flex-col items-center justify-center font-body text-text-main dark:text-gray-100 antialiased overflow-hidden relative">
        <div class="absolute top-0 left-0 w-full h-full overflow-hidden -z-10 pointer-events-none">
            <div class="absolute -top-[20%] -right-[10%] w-[600px] h-[600px] bg-primary/5 rounded-full blur-3xl"></div>
            <div
                class="absolute bottom-[10%] -left-[10%] w-[500px] h-[500px] bg-[#f3d5d5]/30 dark:bg-[#361b1b]/40 rounded-full blur-3xl">
            </div>
        </div>
        <main class="w-full max-w-md px-6 py-8 relative z-10">
            <div class="flex flex-col items-center justify-center mb-8">
                <div class="mb-12 flex items-center gap-4">
                    <img src="https://swangroup.sa/wp-content/uploads/2023/09/5FA061E1-81B7-477E-A650-A3EBE6B30088-e1734439779218.png"
                        width="120" height="120" alt="">
                </div>
                <div
                    class="bg-surface-light dark:bg-surface-dark rounded-2xl shadow-card border border-primary/5 dark:border-primary/10 p-8 sm:p-10 w-full relative overflow-hidden">
                    <div
                        class="absolute top-0 left-0 w-full h-1 bg-gradient-to-r from-primary/0 via-primary/40 to-primary/0">
                    </div>
                    <div class="text-center mb-8 space-y-3">
                        <h1 class="text-2xl sm:text-3xl font-bold text-gray-900 dark:text-white tracking-tight">التحقق
                            بخطوتين
                        </h1>
                        <p class="text-text-muted dark:text-gray-400 text-sm leading-relaxed">
                            لقد قمنا بإرسال رمز تحقق إلى هاتفك الجوال المنتهي بـ <span
                                class="font-bold text-primary dir-ltr" dir="ltr">**98</span>. <br
                                class="hidden sm:block" />يرجى إدخال الرمز أدناه للمتابعة.
                        </p>
                    </div>
                    <form action="#" class="space-y-8" method="POST" onsubmit="event.preventDefault();">
                        <div class="flex justify-center gap-3 sm:gap-4" dir="ltr">
                            <input autofocus=""
                                class="w-12 h-14 sm:w-14 sm:h-16 text-center text-2xl font-bold bg-white dark:bg-gray-800/50 border border-gray-200 dark:border-gray-700 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary/20 focus:border-primary text-primary transition-all shadow-sm placeholder-gray-300 hover:border-primary/30"
                                maxlength="1" placeholder="-" type="number" />
                            <input
                                class="w-12 h-14 sm:w-14 sm:h-16 text-center text-2xl font-bold bg-white dark:bg-gray-800/50 border border-gray-200 dark:border-gray-700 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary/20 focus:border-primary text-primary transition-all shadow-sm placeholder-gray-300 hover:border-primary/30"
                                maxlength="1" placeholder="-" type="number" />
                            <input
                                class="w-12 h-14 sm:w-14 sm:h-16 text-center text-2xl font-bold bg-white dark:bg-gray-800/50 border border-gray-200 dark:border-gray-700 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary/20 focus:border-primary text-primary transition-all shadow-sm placeholder-gray-300 hover:border-primary/30"
                                maxlength="1" placeholder="-" type="number" />
                            <input
                                class="w-12 h-14 sm:w-14 sm:h-16 text-center text-2xl font-bold bg-white dark:bg-gray-800/50 border border-gray-200 dark:border-gray-700 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary/20 focus:border-primary text-primary transition-all shadow-sm placeholder-gray-300 hover:border-primary/30"
                                maxlength="1" placeholder="-" type="number" />
                        </div>
                        <div class="text-center">
                            <p class="text-sm text-text-muted dark:text-gray-400">
                                لم يصلك الرمز؟
                                <button
                                    class="text-primary hover:text-primary-dark font-semibold mr-1 transition-colors disabled:opacity-50 disabled:cursor-not-allowed decoration-1 underline-offset-4 hover:underline"
                                    type="button">
                                    إعادة الإرسال
                                </button>
                                <span
                                    class="mr-1 text-gray-400 font-medium bg-gray-50 dark:bg-white/5 px-2 py-0.5 rounded text-xs"
                                    dir="ltr">00:30</span>
                            </p>
                        </div>
                        <div class="space-y-4">
                            <button
                                class="w-full flex items-center justify-center py-3.5 px-4 border border-transparent rounded-lg shadow-glow text-base font-bold text-white bg-primary hover:bg-primary-dark focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary transition-all duration-200 transform hover:-translate-y-0.5"
                                type="submit">
                                <span class="ml-2">تحقق والدخول</span>
                                <span class="material-symbols-outlined text-[20px]">arrow_back</span>
                            </button>
                            <button
                                class="w-full flex items-center justify-center py-2.5 px-4 rounded-lg text-sm font-medium text-text-muted hover:text-primary dark:text-gray-400 dark:hover:text-white bg-transparent hover:bg-primary/5 dark:hover:bg-white/5 transition-colors"
                                type="button">
                                <span class="material-symbols-outlined text-[18px] ml-1">undo</span>
                                تراجع
                            </button>
                        </div>
                    </form>
                </div>
                <div class="mt-8 text-center space-y-2">
                    <p class="text-xs text-gray-400 dark:text-gray-500">
                        محمي بواسطة reCAPTCHA وتطبق
                        <a class="hover:text-primary hover:underline transition-colors" href="#">سياسة الخصوصية</a> و
                        <a class="hover:text-primary hover:underline transition-colors" href="#">شروط الخدمة</a>.
                    </p>
                </div>
        </main>
        <script>
            document.addEventListener('DOMContentLoaded', () => {
                const inputs = document.querySelectorAll('input[type="number"]');
                inputs.forEach((input, index) => {
                    input.addEventListener('keydown', (e) => {
                        if (e.key === 'Backspace' && !e.target.value && index > 0) {
                            inputs[index - 1].focus();
                        }
                        if (e.key === 'Enter') {
                            e.preventDefault();
                        }
                    });
                    input.addEventListener('input', (e) => {
                        const value = e.target.value;
                        if (value.length === 1 && index < inputs.length - 1) {
                            inputs[index + 1].focus();
                        }
                    });
                    input.addEventListener('paste', (e) => {
                        e.preventDefault();
                        const text = (e.clipboardData || window.clipboardData).getData('text');
                        if (!/^[0-9]+$/.test(text)) return;
                        const digits = text.split('');
                        let currentInput = index;
                        digits.forEach(digit => {
                            if (currentInput < inputs.length) {
                                inputs[currentInput].value = digit;
                                currentInput++;
                            }
                        });
                        if (currentInput < inputs.length) {
                            inputs[currentInput].focus();
                        } else {
                            inputs[inputs.length - 1].blur();
                        }
                    });
                });
            });
        </script>

    </body>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.auth', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Work\Laravel\swan-salon-dashboard\resources\views/auth/login/2fa.blade.php ENDPATH**/ ?>