
<div id="bookingOverlay" onclick="closeBookingDrawer()" class="fixed inset-0 bg-black/40 backdrop-blur-sm z-40 hidden">
</div>

<div id="bookingDrawer" class="fixed inset-y-0 left-0 w-full max-w-md bg-white shadow-2xl z-50
           transform -translate-x-full transition-transform duration-300
           flex flex-col border-r border-border-color">

    <!-- Header -->
    <div class="px-6 py-5 border-b border-border-color flex items-center justify-between bg-primary-subtle">
        <h3 class="text-xl font-bold text-text-main">حجز جديد</h3>
        <button onclick="closeBookingDrawer()"
            class="size-9 flex items-center justify-center rounded-full hover:bg-white text-text-muted transition">
            <span class="material-symbols-outlined">close</span>
        </button>
    </div>

    <!-- Content -->
    <div class="flex-1 overflow-y-auto p-6 space-y-6 bg-background-light">

        <!-- Client -->
        <div>
            <label class="block text-sm font-bold mb-2">العميل</label>
            <div class="relative">
                <input type="text" placeholder="ابحث بالاسم أو رقم الهاتف"
                    class="w-full h-12 pr-11 pl-4 border border-border-color rounded-xl focus:border-primary focus:ring-1 focus:ring-primary outline-none" />
                <span class="material-symbols-outlined absolute top-3.5 right-3.5 text-text-muted">
                    search
                </span>
            </div>
            <button class="text-xs text-primary font-bold mt-2 hover:underline">
                + إضافة عميل جديد
            </button>
        </div>

        <!-- Services -->
        <div>
            <label class="block text-sm font-bold mb-3">الخدمات</label>

            <div class="space-y-3">
                <label
                    class="flex items-center gap-4 p-4 border border-primary bg-primary-subtle rounded-xl cursor-pointer">
                    <input type="checkbox" checked class="size-5 text-primary rounded">
                    <div class="flex-1">
                        <div class="flex justify-between font-bold">
                            <span>قص شعر</span>
                            <span class="text-primary">150 ر.س</span>
                        </div>
                        <span class="text-xs text-text-muted flex items-center gap-1">
                            <span class="material-symbols-outlined text-[12px]">schedule</span>
                            45 دقيقة
                        </span>
                    </div>
                </label>

                <label
                    class="flex items-center gap-4 p-4 border border-border-color rounded-xl cursor-pointer hover:border-primary/50">
                    <input type="checkbox" class="size-5 text-primary rounded">
                    <div class="flex-1">
                        <div class="flex justify-between font-bold">
                            <span>صبغة شعر</span>
                            <span>250 ر.س</span>
                        </div>
                        <span class="text-xs text-text-muted flex items-center gap-1">
                            <span class="material-symbols-outlined text-[12px]">schedule</span>
                            90 دقيقة
                        </span>
                    </div>
                </label>
            </div>
        </div>

        <!-- Staff -->
        <div>
            <label class="block text-sm font-bold mb-2">الموظفة</label>
            <select
                class="w-full h-12 border border-border-color rounded-xl px-4 focus:border-primary focus:ring-1 focus:ring-primary">
                <option>نورة العلي</option>
                <option>سارة حسن</option>
                <option>أي موظفة</option>
            </select>
        </div>

        <!-- Date & Time -->
        <div>
            <label class="block text-sm font-bold mb-2">التاريخ</label>
            <input type="date"
                class="w-full h-12 border border-border-color rounded-xl px-4 focus:border-primary focus:ring-1 focus:ring-primary" />
        </div>

        <div>
            <label class="block text-sm font-bold mb-2">الوقت</label>
            <div class="grid grid-cols-4 gap-2">
                <button class="py-2 text-xs rounded-lg border hover:border-primary">02:00</button>
                <button class="py-2 text-xs rounded-lg bg-primary text-white">02:30</button>
                <button class="py-2 text-xs rounded-lg border text-gray-400 cursor-not-allowed">03:00</button>
                <button class="py-2 text-xs rounded-lg border hover:border-primary">03:30</button>
            </div>
        </div>

        <!-- Notes -->
        <div>
            <label class="block text-sm font-bold mb-2">ملاحظات</label>
            <textarea rows="3" placeholder="ملاحظات إضافية..."
                class="w-full border border-border-color rounded-xl p-4 focus:border-primary focus:ring-1 focus:ring-primary resize-none"></textarea>
        </div>

    </div>

    <!-- Footer -->
    <div class="p-6 border-t border-border-color bg-white">
        <div class="flex justify-between mb-4">
            <span class="text-sm text-text-muted font-bold">الإجمالي</span>
            <span class="text-2xl font-black text-primary">150 ر.س</span>
        </div>

        <div class="flex gap-3">
            <button onclick="closeBookingDrawer()" class="flex-1 h-12 border rounded-xl font-bold">
                إلغاء
            </button>
            <button class="flex-[2] h-12 bg-primary text-white rounded-xl font-bold">
                تأكيد الحجز
            </button>
        </div>
    </div>

</div><?php /**PATH D:\Work\Laravel\swan-salon-dashboard\resources\views/components/bookings/booking-drawer.blade.php ENDPATH**/ ?>